Option Explicit

' Required data structures
Type RECT
   left As Integer
   top As Integer
   right As Integer
   bottom As Integer
End Type

Type PAINTSTRUCT
   hdc As Integer
   fErase As Integer
   rcPaint As RECT
   fRestore As Integer
   fIncUpdate As Integer
   rgbReserved As String * 16
End Type

' Clipboard Manager Functions
Declare Function OpenClipboard Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function CloseClipboard Lib "User" () As Integer
Declare Function GetClipboardOwner Lib "User" () As Integer
Declare Function SetClipboardViewer Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function GetClipboardViewer Lib "User" () As Integer
Declare Function ChangeClipboardChain Lib "User" (ByVal hWnd As Integer, ByVal hWndNext As Integer) As Integer
Declare Function SetClipboardData Lib "User" (ByVal wFormat As Integer, ByVal hMem As Integer) As Integer
Declare Function GetClipboardData Lib "User" (ByVal wFormat As Integer) As Integer
Declare Function RegisterClipboardFormat Lib "User" (ByVal lpString As String) As Integer
Declare Function CountClipboardFormats Lib "User" () As Integer
Declare Function EnumClipboardFormats Lib "User" (ByVal wFormat As Integer) As Integer
Declare Function GetClipboardFormatName Lib "User" (ByVal wFormat As Integer, ByVal lpString As String, ByVal nMaxCount As Integer) As Integer
Declare Function EmptyClipboard Lib "User" () As Integer
Declare Function IsClipboardFormatAvailable Lib "User" (ByVal wFormat As Integer) As Integer
Declare Function GetPriorityClipboardFormat Lib "User" (lpPriorityList As Integer, ByVal nCount As Integer) As Integer

' Other required Win16 APIs
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Sub HMemCpy Lib "kernel" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
Declare Sub GetClientRect Lib "User" (ByVal hWnd As Integer, lpRect As RECT)

' Clipboard Window Messages
Global Const WM_RENDERFORMAT = &H305
Global Const WM_RENDERALLFORMATS = &H306
Global Const WM_DESTROYCLIPBOARD = &H307
Global Const WM_DRAWCLIPBOARD = &H308
Global Const WM_PAINTCLIPBOARD = &H309
Global Const WM_VSCROLLCLIPBOARD = &H30A
Global Const WM_SIZECLIPBOARD = &H30B
Global Const WM_ASKCBFORMATNAME = &H30C
Global Const WM_CHANGECBCHAIN = &H30D
Global Const WM_HSCROLLCLIPBOARD = &H30E

' Predefined Clipboard Formats
Global Const CF_TEXT = 1
Global Const CF_BITMAP = 2
Global Const CF_METAFILEPICT = 3
Global Const CF_SYLK = 4
Global Const CF_DIF = 5
Global Const CF_TIFF = 6
Global Const CF_OEMTEXT = 7
Global Const CF_DIB = 8
Global Const CF_PALETTE = 9
Global Const CF_OWNERDISPLAY = &H80
Global Const CF_DSPTEXT = &H81
Global Const CF_DSPBITMAP = &H82
Global Const CF_DSPMETAFILEPICT = &H83

' Global memory flags
Global Const GMEM_FIXED = &H0
Global Const GMEM_ZEROINIT = &H40

Function MakeLong (WordHi As Variant, WordLo%) As Long
  MakeLong = (WordHi * &H10000) + (WordLo And &HFFFF&)
End Function

Function WordHi (LongIn&) As Integer
   WordHi = (LongIn And &HFFFF0000) \ &H10000
End Function

Function WordLo (LongIn&) As Integer
   If (LongIn And &HFFFF&) > &H7FFF Then
      WordLo = (LongIn And &HFFFF&) - &H10000
   Else
      WordLo = LongIn And &HFFFF&
   End If
End Function

