/*
**  STRDEL.C - Removes specified characters from a string
**
**  public domain demo by Bob Stout
*/

#include <string.h>
#include "snip_str.h"

char *_strdel(char *str, size_t posn, size_t len)
{
      char *pos0, *pos1;

      if (str)
      {
            if (posn < strlen(str))
            {
                  for (pos0 = pos1 = str + posn;
                        *pos1 && len;
                        ++pos1, --len)
                  {
                        ;
                  }
                  strmove(pos0, pos1);
            }
      }
      return str;
}

#ifdef TEST

#include <stdio.h>
#include <stdlib.h>

main(int argc, char *argv[])
{
      int pos, len;

      if (4 > argc)
      {
            puts("Usage: STRDEL string pos len");
            puts("Deletes 'len' characters starting at position 'pos'");
            return EXIT_FAILURE;
      }
      pos = atoi(argv[2]);
      len = atoi(argv[3]);
      printf("_strdel(\"%s\", %d, %d) => ", argv[1], pos, len);
      printf("\"%s\"\n", _strdel(argv[1], pos, len));
      return EXIT_SUCCESS;
}

#endif /* TEST */
