/*
**  Header file for SNIPPETS string manipulation functions
*/

#ifndef SNIP_STR__H
#define SNIP_STR__H

#include <stddef.h>                       /* For size_t and NULL        */
#include "sniptype.h"                     /* For LAST_CHAR() & NUL      */

/*
**  Macros to print proper plurals by Bob Stout
*/

#define plural_text(n) &"s"[(1 == (n))]
#define plural_text2(n) &"es"[(1 == (n)) << 1]
#define plural_text3(n) &"y\0ies"[(1 != (n)) << 1]

/*
**  Safe string macros by Keiichi Nakasato
*/

/* strncpy() variants that are guaranteed to append NUL                 */

#define strn1cpy(d,s,n) (strncpy(d,s,n),(d)[n]=0,d)
#define strn0cpy(d,s,n) strn1cpy(d,s,(n)-1)

/* like strcpy, except guaranteed to work with overlapping strings      */

#define strmove(d,s) memmove(d,s,strlen(s)+1)


/*
**  Prototypes
*/

#if defined(__STDC__) && __STDC__
 #define strdup _strdup
 #define stristr _stristr
 #define strrev _strrev
 #define strrpbrk _strrpbrk
 #define strupr _strupr
 #define strlwr _strlwr
#endif

char *sstrcpy(char *to, char *from);                  /* Sstrcpy.C      */
char *sstrcat(char *to, char *from);                  /* Sstrcpy.C      */
char *sstrdel(char *s, ...);                          /* Sstrdel.C      */
char *stptok(const char *s, char *tok, size_t toklen,
      char *brk);                                     /* Stptok.C       */
char *_strchcat(char *string, int ch, size_t buflen); /* Strchat.C      */
char *_strdel(char *string, size_t first, size_t len);/* Strdel.C       */
char *_strdelch(char *string, const char *lose);      /* Strdelch.C     */
char *strdup(const char *string);                     /* Strdup.C       */
char *_strecpy(char *target, const char *src);        /* Strecpy.C/Asm  */
char *stristr(char *String, char *Pattern);           /* Stristr.C      */
char *_strrepl(char *Str, size_t BufSiz,
      char *OldStr, char *NewStr);                    /* Strrepl.C      */
char *strrev(char *str);                              /* Strrev.C       */
char *strrpbrk(const char *szString,
      const char *szChars);                           /* Strrpbrk.C     */
char *strupr(char *string);                           /* Strupr.C       */
char *strlwr(char *string);                           /* Strupr.C       */
char *translate(char *string);                        /* Translat.C     */
char *xstrcat(char *des, char *src, ...);             /* Xstrcat.C      */
char *rule_line(char * s, unsigned short len,
      short units, char * digits, char filler);       /* Ruleline.C     */
char *rmallws(char *str);                             /* Rmallws.C      */
char *rmlead(char *str);                              /* Rmlead.C       */
char *rmtrail(char *str);                             /* Rmtrail.C      */
char *trim (char *str);                               /* Trim.C         */
void lv1ws(char *str);                                /* Lv1Ws.C        */

#endif /*  SNIP_STR__H */
