/*
**  SETENVAR.C - Program which sets the DOS master environment upon exit
**
**  Original Copyright 1988-1991 by Bob Stout as part of
**  the MicroFirm Function Library (MFL)
**
**  This subset version is functionally identical to the
**  version originally published by the author in Tech Specialist
**  magazine and is hereby donated to the public domain.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include "sniptype.h"
#include "pchwio.h"
#include "errors.h"                       /* For cant()     */

static unsigned head, tail, start, end;
static int idx = 0;
static unsigned keystack[16][2];

/*
**  ungetkey()
**
**  Stuffs characters into the keyboard buffer.
**
**  Parameters: 1 - Extended character to stuff
**
**  Returns: Success_ or EOF
**
**  Note: This function assumes that the keyboard buffer is in
**        the normal (for IBM) location of 40:1E.
**
*/

int ungetkey(unsigned key)
{
      int count;

      head  = peek(0x40, 0x1a);
      tail  = peek(0x40, 0x1c);
      start = peek(0x40, 0x80);
      end   = peek(0x40, 0x82);

      count = tail - head;
      if (0 > count)
            count += (16 * sizeof(unsigned));
      count >>= 1;

      if (15 > count)
      {
            disable();
            keystack[idx][0] = peek(0x40, tail);
            keystack[idx][1] = tail;
            poke(0x40, tail, key);
            tail += sizeof(unsigned);
            if (end <= tail)
                  tail = start;
            poke(0x40, 0x1c, tail);
            enable();
            return key;
      }
      return EOF;
}

/*
**  KB_stuff()
**
**  Stuffs strings into the keyboard buffer.
**
**  Parameters: 1 - String to stuff
**
**  Returns: Success_ if successful
**           Error_   in case of error, plus keyboard buffer is
**                    restored
**
**  Note: This function assumes that the keyboard buffer is in
**        the normal (for IBM) location of 40:1E.
*/

int KB_stuff(char *str)
{
      int ercode = Success_;

      idx = 0;
      while (*str)
      {
            if (EOF == ungetkey((unsigned)(*str++)))
            {
                  disable();
                  while (0 <= --idx)
                  {
                        tail = keystack[idx][1];
                        poke(0x40, tail, keystack[idx][0]);
                  }
                  poke(0x40, 0x1c, tail);
                  enable();
                  ercode = Error_;
                  break;
            }
            else  ++idx;
      }
      idx = 0;
      return ercode;
}

main(int argc, char *argv[])
{
      FILE *bfile;

      if (3 > argc)
      {
            puts("\aUsage: SETENVAR envar datum");
            abort();
      }
      bfile = cant("$TMP$.BAT", "w");
      fprintf(bfile, "SET %s=%s\ndel $tmp$.bat\x1a", argv[1], argv[2]);
      fclose(bfile);
      while (kbhit())
            getch();
      KB_stuff("$tmp$\r");
      return 0;
}
