/*-------------------------[ IsShift ]--------------------------*/
/*           Determine whether a shift key is depressed         */
/*              public domain snippet by Jeff Dunlop            */
/*--------------------------------------------------------------*/
/* local:                                                       */
/*      key_flags = pointer to bios shift key area              */
/* return:                                                      */
/*      1 if either shift key is depressed                      */
/*--------------------------------------------------------------*/

#include "extkword.h"
#include "snipkbio.h"
#include "mk_fp.h"


int IsShift(void)
{
    unsigned char FAR *keyflags = MK_FP(0x40, 0x17);

    return (*keyflags & 0x03);
}

int IsAlt(void)
{
    unsigned char FAR *keyflags1 = MK_FP(0x40, 0x17),
                  FAR *keyflags2 = MK_FP(0x40, 0x18);

    return (*keyflags1 & 0x08) || (*keyflags2 & 0x02);
}

int IsCtl(void)
{
    unsigned char FAR *keyflags1 = MK_FP(0x40, 0x17),
                  FAR *keyflags2 = MK_FP(0x40, 0x18);

    return (*keyflags1 & 0x04) || (*keyflags2 & 0x01);
}

int IsSysRq(void)
{
    unsigned char FAR *keyflags = MK_FP(0x40, 0x18);

    return (*keyflags & 0x04);
}
