/*
**  ext_getch()
**
**  A getch() work-alike for use with extended keyboards.
**
**  Parameters: none
**
**  Returns: Extended key code as follows:
**           0->255     Normal key
**           256->511   Numeric pad key or Function key
**           512->767   Cursor pad key or Numeric pad
**                      "duplicate" key (Enter, /, *, -, +)
**
**  Original Copyright 1992 by Bob Stout as part of
**  the MicroFirm Function Library (MFL)
**
**  This subset version is hereby donated to the public domain.
*/

#include <dos.h>
#include <ctype.h>
#include "hilobyte.h"
#include "snipkbio.h"
#include "ext_keys.h"

int ext_getch(void)
{
      int key;
      union REGS regs;

      regs.h.ah = 0x10;
      int86(0x16, &regs, &regs);
      key = regs.x.ax;

      switch (LoByte(key))
      {
      case 0:
            key = HiByte(key) + 256;
            break;

      case 0xe0:
            key = HiByte(key) + 512;
            break;

      default:
            if (0xe0 == HiByte(key))
                  key = LoByte(key) + 512;
            else
            {
                  if (ispunct(LoByte(key)) && HiByte(key) > 0x36)
                        key = LoByte(key) + 512;
                  else  key = LoByte(key);
            }
      }
      return key;
}

int GetExtKey(int *isshift)
{
      int key =  ext_getch();

      *isshift = IsShift();
      return key;
}

#ifdef TEST

#include <stdio.h>

main()
{
      int key0, key1, shift;

      puts("Hit keys, Esc twice to stop\n");
      for ( key0 = key1 = 0; !(key1 == Key_ESC && key0 == Key_ESC); )
      {
            key0 = key1;
            key1 = GetExtKey(&shift);
            printf("ext_getch() returned %0Xh, Shift is O%s\n",
                  key1, shift ? "n" : "ff");
      }
      return 0;
}

#endif /* TEST */
