unit Demo1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, RptWorks, DBTables,
  DB;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ScrollBox1: TScrollBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Bevel1: TBevel;
    ReportWorks1: TReportWorks;
    CustSource: TDataSource;
    Cust: TTable;
    CustCustNo: TFloatField;
    CustCompany: TStringField;
    CustAddr1: TStringField;
    CustAddr2: TStringField;
    CustCity: TStringField;
    CustState: TStringField;
    CustZip: TStringField;
    CustPhone: TStringField;
    OrderSource: TDataSource;
    Orders: TTable;
    OrdersOrderNo: TFloatField;
    OrdersCustNo: TFloatField;
    OrdersPaymentMethod: TStringField;
    OrdersItemsTotal: TCurrencyField;
    OrdersAmountPaid: TCurrencyField;
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
    function GetParagraph:pchar;
    procedure PrintHeader;
    procedure PrintReport;
    procedure UpdatePageStatus;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  ABuffer:pchar;

implementation

{$R *.DFM}

procedure TForm1.FormResize(Sender: TObject);
begin
  {Make sure buttons appear in right position.}
  if Width < 435 then Width := 435;
  BitBtn1.Left := Panel1.Width - 181;
  BitBtn2.Left := Panel1.Width - 85;
end;

procedure TForm1.UpdatePageStatus;
begin
  {Update current report page.}
  Label1.Caption := 'Page ' + IntToStr(ReportWorks1.CurrentPage)
                    + ' of ' + IntToStr(ReportWorks1.PageTotal);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  {Make sure buttons appear in right position.}
  if Width < 435 then Width := 435;
  BitBtn1.Left := Panel1.Width - 181;
  BitBtn2.Left := Panel1.Width - 85;
  {Set database range - don't need whole database for demo.}
  Cust.SetRange([1221],[1510]);
  {Print the report to the screen.}
  PrintReport;
end;

procedure TForm1.PrintReport;
var ABitMap:TBitMap;
    x:integer;
    TotalMiles,TotalGas:integer;
    shade:boolean;
    tmpstr:string;
begin
{Get bitmap, if it exists.}
try
ABitMap := TBitMap.Create;
ABitMap.LoadFromFile('c:\delphi\images\splash\16color\athena.bmp');
except
on Exception do ShowMessage('Athena bitmap not found!'); end;
with ReportWorks1 do
  begin
  {Margins change later so make sure they are set
   properly on future calls.}
  LeftMargin := 1;
  RightMargin := 1;
  if Destination = dPreview then Screen.Cursor := crHourGlass;
  StartDoc;
  SetTab(1.25,jLeft);
  { Use StectchGraphic instead of PositionGraphic as different
    printer resolutions will affect size of bitmap with PositionGraphic. }
  StretchGraphic(2.5,0,4,1.5,ABitMap);
  for x := 1 to 8 do NextLine;
  SetFont('Arial',14);
  FontBold;
  Print('Technical Report');
  NextLine;
  NextLine;
  DrawLIne;
  NextLine;
  SetFont('Arial',10);
  Print('To:');
  PrintTab(1,'Delphi Programmer');
  NextLine;
  Print('From:');
  PrintTab(1,'HSoftWare');
  NextLine;
  FontRegular;
  Print('Product:');
  PrintTab(1,'ReportWorks Component');
  NextLine;
  Print('Version:');
  PrintTab(1,'1.00');
  NextLine;
  Print('Author:');
  PrintTab(1,'Howard S. Walsh');
  NextLine;
  Print('Features:');
  PrintTab(1,'Plenty');
  NextLine;
  Print('   Preview:');
  PrintTab(1,'Yes');
  NextLine;
  Print('   Status Screen:');
  PrintTab(1,'Yes');
  NextLine;
  Print('   Demo:');
  PrintTab(1,'Yes');
  NextLine;
  Print('Date:');
  PrintTab(1,DateToStr(Date));
  NextLine;
  FontBold;
  Print('Subject:');
  PrintTab(1,'Product Description');
  NextLine;
  NextLine;
  FontRegular;
  DrawLine;
  NextLine;
  NextLine;
  PrintParagraph(GetParagraph);
  {Report page 2}
  NewPage;
  ClearTabs;
  LineWidth := lwDouble;
  DrawLine;
  NextLine;
  SetFont('Arial',16);
  PrintCenter('Car Expense Report');
  NextLine;
  NextLine;
  SetFont('Arial',12);
  FontItalic;
  PrintLeft(DateToStr(Date));
  NextLine;
  LineWidth := lwNormal;
  DrawLine;
  SetTab(1.5,jLeft);
  SetTab(4.5,jRight);
  SetTab(6.5,jRight);
  NextLine;
  FontRegular;
  FontBold;
  Print('Date');
  PrintTab(1,'Description');
  PrintTab(2,'Mileage');
  PrintTab(3,'Gas');
  FontRegular;
  NextLine;
  TotalMiles := 0;
  TotalGas := 0;
  for x := 0 to 25 do
     begin
     Print(DateToStr(Date + x));
     PrintTab(1,'Business Trip');
     PrintTab(2,IntToStr(x * 15));
     PrintTab(3,IntToStr(x * 8) + '.00');
     TotalMiles := TotalMiles + (x*15);
     TotalGas := TotalGas + (x * 8);
     NextLine;
     end;
  NextLine;
  FontBold;
  PrintTab(2,IntToStr(TotalMiles));
  PrintTab(3,IntToStr(TotalGas) + '.00');
  FontRegular;
  GoToPageBottom;
  DrawLine;
  {Report page 3}
  NewPage;
  ClearTabs;
  ShadeLine(clRed);
  DrawLine;
  NextLine;
  ShadeLine(clRed);
  NextLine;
  ShadeLine(clRed);
  PreviousLine;
  PreviousLine;
  SetFont('Arial',16);
  PrintCenter('ReportWorks Sales Report');
  NextLine;
  NextLine;
  SetFont('Arial',12);
  PrintRight(DateToStr(Date));
  NextLine;
  DrawLine;
  SetTab(1.25,jLeft);
  SetTab(3,jCenter);
  SetTab(4.5,jRight);
  SetTab(6.5,jRight);
  FontBold;
  Print('Date');
  PrintTab(1,'Software');
  PrintTab(2,'Sold');
  PrintTab(3,'Unit');
  PrintTab(4,'Price');
  FontRegular;
  NextLine;
  shade := true;
  for x := 1 to 35 do
     begin
     if shade then ShadeLine(clYellow);
     shade := not shade;
     Print(DateToStr(Date + x));
     PrintTab(1,'ReportWorks');
     PrintTab(2,IntToStr(x));
     PrintTab(3,'29.00');
     { This is just faster (easier) }
     PrintTab(4,IntToStr(x*29) + '.00');
     NextLine;
     end;
  while not IsPageEnd do
     begin
     if shade then ShadeLine(clYellow);
     shade := not shade;
     NextLine;
     end;
  {Report page 4 - MAST database demo.}
  NewPage;
  ClearTabs;
  LeftMargin := 0.5;
  RightMargin := 0.5;
  GoToPageTop;
  {Tabs for company info.}
  SetTab(0.4,jLeft);
  SetTab(3.5,jLeft);
  SetTab(5.1,jLeft);
  SetTab(6.0,jLeft);
  SetTab(7.5,jRight);
  {Tabs for order info.}
  SetTab(1,jLeft);
  SetTab(2,jLeft);
  SetTab(4.8,jRight);
  SetTab(6.0,jRight);
  {Make sure we are on the first record.}
  Cust.First;
  PrintHeader;
  while not Cust.EOF do
     begin
     {Shade two lines.}
     ShadeLine(clBlue);
     NextLine;
     ShadeLine(clBlue);
     PreviousLine;
     {FontColor is a new procedure - undocumented in current version.}
     FontColor(clYellow);
     SetFont('Arial',8);
     Print(CustCustNo.AsString);
     SetFont('Arial',14);
     PrintTab(1,CustCompany.Value);
     SetFont('Arial',10);
     PrintTab(2,CustAddr1.Value);
     PrintTab(3,CustCity.Value);
     PrintTab(4,CustState.Value);
     PrintTab(5,CustPhone.Value + '  ');
     NextLine;
     SetFont('Arial',8);
     FontItalic;
     PrintTab(6,'Order No.');
     PrintTab(7,'Payment Method');
     PrintTab(8,'Total');
     PrintTab(9,'Amount Paid');
     NextLine;
     FontRegular;
     SetFont('Arial',10);
     if IsPageEnd then
        begin
        NewPage;
        PrintHeader;
        end;
     while not Orders.EOF do
        begin
        FontColor(clBlack);
        PrintTab(6,IntToStr(round(OrdersOrderNo.Value)));
        PrintTab(7,OrdersPaymentMethod.Value);
        Str(OrdersItemsTotal.Value:8:2,tmpstr);
        PrintTab(8,tmpstr);
        Str(OrdersAmountPaid.Value:8:2,tmpstr);
        PrintTab(9,tmpstr);
        NextLine;
        if IsPageEnd then
          begin
          NewPage;
          PrintHeader;
          end;
        Orders.Next;
        end;
     NextLine;
     Cust.Next;
     end;
  EndDoc;
  Screen.Cursor := crDefault;
  end;
ABitMap.Free;
UpdatePageStatus;
end;

procedure TForm1.PrintHeader;
{Header for MAST database report.}
begin
  with ReportWorks1 do
     begin
     FontBold;
     FontColor(clBlue);
     SetFont('Times Roman',42);
     Print('MAST');
     SetFont('Arial',16);
     NextLine;
     PrintRight('Marine Adventure Sales Report');
     NextLine;
     NextLine;
     ShadeLine(clBlue);
     FontColor(clYellow);
     SetFont('Arial',10);
     Print(' ReportWorks for Delphi Sample Report');
     FontItalic;
     PrintRight(DateToStr(Date)+'  ');
     FontColor(clBlack);
     FontRegular;
     NextLine;
     NextLine;
     end;
end;


function TForm1.GetParagraph:pchar;
{Buffer to show PrintParagraph - could use memo database field.}
const ABuf1:pchar = 'The ReportWorks component is designed to provide fast,';
      ABuf2:pchar = ' simple, hasslefree reporting functionality. Reports can';
      ABuf3:pchar = ' be previewed, printed to the printer or printed to file.';
      ABuf4:pchar = ' Columns can be established in the form of tabs with left,';
      ABuf5:pchar = ' right and center justification.  Lines, or rows, can be';
      ABuf6:pchar = ' shaded, if so desired.' + #10 + #13 + #13;
      ABuf7:pchar = 'Output can be printed with or without linefeed, left,';
      ABuf8:pchar = ' right or center justified. Large strings, longer than';
      ABuf9:pchar = ' 255 characters, can be output with automatic word-wrap';
      ABuf10:pchar = ' within the established page margins.' + #13 + #13 + #10;
      ABuf11:pchar = 'Printer page units can be set to Inches, Millimeters or';
      ABuf12:pchar = ' Points. Once margins are set, all printing occurs';
      ABuf13:pchar = ' within these boundaries.' + #13 + #13 + #10;
      ABuf14:pchar = 'Graphics functionality is available, and bitmaps, icons';
      ABuf15:pchar = ' and metafiles can be imported to the page.' + #13 + #13 + #10;
      ABuf16:pchar = 'See following pages for additional report styles.';
begin
GetMem(ABuffer,5000);
StrCopy(ABuffer, ABuf1);
StrCat(ABuffer, ABuf2);
StrCat(ABuffer, ABuf3);
StrCat(ABuffer, ABuf4);
StrCat(ABuffer, ABuf5);
StrCat(ABuffer, ABuf6);
StrCat(ABuffer, ABuf7);
StrCat(ABuffer, ABuf8);
StrCat(ABuffer, ABuf9);
StrCat(ABuffer, ABuf10);
StrCat(ABuffer, ABuf11);
StrCat(ABuffer, ABuf12);
StrCat(ABuffer, ABuf13);
StrCat(ABuffer, ABuf14);
StrCat(ABuffer, ABuf15);
StrCat(ABuffer, ABuf16);
Result := ABuffer;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  ReportWorks1.NextPage;
  PrintReport;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ReportWorks1.PreviousPage;
  PrintReport
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  ReportWorks1.LastPage;
  PrintReport;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ReportWorks1.FirstPage;
  PrintReport;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
{Change destination to the printer, print report and reset destination.}
begin
  ReportWorks1.Destination := dPrinter;
  PrintReport;
  ReportWorks1.Destination := dPreview;
end;

end.
