unit Testrep;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Quickrep, StdCtrls, DBCtrls, DB, DBTables,
  ToCtrl;

type
  TTestReport = class(TForm)
    DemoReport: TQuickReport;
    DataSource1: TDataSource;
    Customer: TTable;
    Title: TQRBand;
    PageHeader: TQRBand;
    Group1Header: TQRBand;
    Alphabetic: TQRGroup;
    Letter: TQRLabel;
    CustomerCompany: TStringField;
    CustomerPhone: TStringField;
    CustomerFAX: TStringField;
    CustomerTaxRate: TFloatField;
    CustomerContact: TStringField;
    Detail: TQRBand;
    QRDBText1: TQRDBText;
    Summary: TQRBand;
    QRDBText2: TQRDBText;
    QRDBText3: TQRDBText;
    PageFooter: TQRBand;
    QRLabel2: TQRLabel;
    QRDBText4: TQRDBText;
    QRSysData2: TQRSysData;
    QRSysData1: TQRSysData;
    QRSysData3: TQRSysData;
    CompanyLabel: TQRLabel;
    ContactLabel: TQRLabel;
    PhoneLabel: TQRLabel;
    FaxLabel: TQRLabel;
    QRSysData4: TQRSysData;
    Label1: TLabel;
    QRLabel1: TQRLabel;
    procedure TitleAfterPrint(BandPrinted : Boolean);
    procedure DemoReportBeforePrint(Sender: TObject);
    procedure Group1HeaderBeforePrint(var PrintBand : Boolean);
    procedure AlphabeticNeedData(var Value: OpenString);
     private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TestReport: TTestReport;

implementation

{$R *.DFM}

procedure TTestReport.DemoReportBeforePrint(Sender : TObject);
begin
   PageHeader.Enabled:=False;             { Disable page header for first page }
end;

procedure TTestReport.TitleAfterPrint(BandPrinted : Boolean);
begin
   PageHeader.Enabled:=True;                  { Enable page header for page 2+ }
end;

procedure TTestReport.AlphabeticNeedData(var Value : OpenString);
begin
   Value:=copy(value,1,1);                        { This group is based on first
                                                       letter in customer name }
end;

procedure TTestReport.Group1HeaderBeforePrint(var PrintBand : Boolean);
begin
   Letter.Caption:=Alphabetic.GroupData;              { Print the first letter }
end;

end.
