Option Explicit

' declare a few API functions that we will be using
Declare Sub WinHelp Lib "User" (ByVal hWnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, ByVal dwData As Long)
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Sub FlashWindow Lib "User" (ByVal hWnd As Integer, ByVal bInvert As Integer)
Global Const BITSPIXEL = 12

'-----------------------------------
'Common Dialog Control
'-----------------------------------
'Action Property
Global Const DLG_FILE_OPEN = 1
Global Const DLG_FILE_SAVE = 2
Global Const DLG_COLOR = 3
Global Const DLG_FONT = 4
Global Const DLG_PRINT = 5
Global Const DLG_HELP = 6

'Color Dialog Flags
Global Const CC_RGBINIT = &H1&
Global Const CC_FULLOPEN = &H2&
Global Const CC_PREVENTFULLOPEN = &H4&
Global Const CC_SHOWHELP = &H8&

Sub SetBevelOptions (F As Form, T As PZPanel)
'*******************************************************
'*                                                     *
'*   Set the bevel and border of a panel to the values *
'*   stored within the tags of a dialog form.          *
'*                                                     *
'*******************************************************

    ReDim opt(1) As Integer
    Dim i As Integer
    
    T.BevelOuter = Val(F!Tabs(0).Tag)
    T.BevelInner = Val(F!Tabs(1).Tag)
    T.BorderOuter = Val(F!Tabs(2).Tag)
    T.BorderInner = Val(F!Tabs(3).Tag)
    T.BevelOuterWidth = Val(F!WidthLab(0))
    T.BevelInnerWidth = Val(F!WidthLab(1))
    T.BorderOuterWidth = Val(F!WidthLab(2))
    T.BorderInnerWidth = Val(F!WidthLab(3))
    For i = 0 To 1
        opt(i) = Val(F!ColorOpt(i * 2 + 1).Tag)
        opt(i) = opt(i) + Val(F!ColorOpt(i * 2).Tag) Xor (opt(i) < 2) And 1
    Next
    T.BevelOuterShading = opt(0)
    T.BevelInnerShading = opt(1)

    T.BorderOuterColor = Val(F!ColorOpt(4).Tag)
    T.BorderInnerColor = Val(F!ColorOpt(6).Tag)
End Sub

Sub ShowBevelOptions (F As Form, T As PZPanel)
'*******************************************************
'*                                                     *
'*   Store the bevel and border settings of a panel    *
'*   within the tags of a dialog form.                 *
'*                                                     *
'*******************************************************

    ReDim opt(1) As Integer
    Dim i As Integer
    
    F!TabPan.Tag = "0" ' set the "up" tab
    F!Tabs(0).Tag = Str$(T.BevelOuter)
    F!Tabs(1).Tag = Str$(T.BevelInner)
    F!Tabs(2).Tag = Str$(T.BorderOuter)
    F!Tabs(3).Tag = Str$(T.BorderInner)
    F!WidthLab(0) = Str$(T.BevelOuterWidth)
    F!WidthLab(1) = Str$(T.BevelInnerWidth)
    F!WidthLab(2) = Str$(T.BorderOuterWidth)
    F!WidthLab(3) = Str$(T.BorderInnerWidth)

    ' setting the bevel shade options is confusing because
    ' the "white light" option reverses its value depending
    ' on the "black shade" option
    opt(0) = T.BevelOuterShading
    opt(1) = T.BevelInnerShading
    For i = 0 To 1
        ' there are four color option buttons, two for each property
        F!ColorOpt(i * 2).Tag = Str$((opt(i) < 2 Xor opt(i)) And 1)
        F!ColorOpt(i * 2 + 1).Tag = Str$(opt(i) And 2)
    Next

    F!ColorOpt(4).Tag = Str$(T.BorderOuterColor)
    F!ColorOpt(6).Tag = Str$(T.BorderInnerColor)
End Sub

Sub CenterForm (F As Form)
    ' put the form in the center of the screen
    F.Move (screen.Width - F.Width) \ 2, (screen.Height - F.Height) \ 2
End Sub

