unit Test;

   {  *** Print Preview Tester ***  }

   { This program puts the Print Preview Component through several tests }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Menus, Mask, TabNotBk, Printers,
  PrntPrev;

type
  TTestForm = class(TForm)
    PrinterSetupDialog1: TPrinterSetupDialog;
    FontDialog1: TFontDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    PrinterSetup1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    PrintPreview2: TPrintPreview;
    FontDialog2: TFontDialog;
    TabbedNotebook1: TTabbedNotebook;
    Font1But: TButton;
    Preview1But: TButton;
    PrintPreview1: TPrintPreview;
    NumColEdit: TMaskEdit;
    Label2: TLabel;
    Label3: TLabel;
    NumRowEdit: TMaskEdit;
    Label4: TLabel;
    Preview2But: TButton;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    LeftMar: TMaskEdit;
    RightMar: TMaskEdit;
    TopMar: TMaskEdit;
    BotMar: TMaskEdit;
    Preview3But: TButton;
    Panel1: TPanel;
    Button3: TButton;
    Label5: TLabel;
    OpenDialog1: TOpenDialog;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    PrintPreview3: TPrintPreview;
    Preview4But: TButton;
    Memo1: TMemo;
    PrintPreview4: TPrintPreview;
    Label1: TLabel;
    FileMemo: TMemo;
    LoadTextBut: TButton;
    FontBut: TButton;
    FontDialog3: TFontDialog;
    OpenDialog2: TOpenDialog;
    Label10: TLabel;
    StartPageEdit: TMaskEdit;
    PortraitBut: TRadioButton;
    LandscapeBut: TRadioButton;
    procedure PrintPreview1PrintPage(var Info: TPageInfo;
      SCanvas: TSpecialCanvas);
    procedure PrintPreview1BeginPrint(var Info: TPageInfo);
    procedure PrintPreview1EndPrint(var Info: TPageInfo);
    procedure Font1ButClick(Sender: TObject);
    procedure Preview1ButClick(Sender: TObject);
    procedure PrinterSetup1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Preview2ButClick(Sender: TObject);
    procedure PrintPreview2PrintPage(var Info: TPageInfo;
      SCanvas: TSpecialCanvas);
    procedure Button3Click(Sender: TObject);
    procedure PrintPreview3PrintPage(var Info: TPageInfo;
      SCanvas: TSpecialCanvas);
    procedure Preview3ButClick(Sender: TObject);
    procedure PrintPreview2BeginPrint(var Info: TPageInfo);
    procedure PrintPreview3BeginPrint(var Info: TPageInfo);
    procedure LoadTextButClick(Sender: TObject);
    procedure FontButClick(Sender: TObject);
    procedure PrintPreview4BeginPrint(var Info: TPageInfo);
    procedure PrintPreview4PrintPage(var Info: TPageInfo;
      SCanvas: TSpecialCanvas);
    procedure Preview4ButClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TestForm: TTestForm;

implementation

{$R *.DFM}

{ Text Example - This example prints one page of text.  The user may
select the margins }

procedure TTestForm.PrintPreview1PrintPage(var Info: TPageInfo;
  SCanvas: TSpecialCanvas);
var
   s, s2  : string;
   x,y    : integer;
   my, mx : single;
   i      : integer;
   lmar,
   rmar,
   tmar,
   bmar   : single;
begin
   lmar := StrToFloat(LeftMar.Text);
   rmar := StrToFloat(RightMar.Text);
   tmar := StrToFloat(TopMar.Text);
   bmar := StrToFloat(BotMar.Text);

   { Only one Page, so set the LastPage flag }
   Info.LastPage := True;

   s := 'This is text line number ';
   SCanvas.Font := FontDialog1.Font;

   x := SCanvas.XInch(lmar);                       { Xinch returns printer units }
   y := SCanvas.YInch(tmar);
   my := SCanvas.PageHeight / SCanvas.Yres - bmar;
   mx := SCanvas.PageWidth - SCanvas.Xinch(rmar);
   i := 1;
   while y+SCanvas.TextHeight(s2)<SCanvas.YInch(my) do begin
      s2 := s + IntToStr(i);
      while (x + SCanvas.TextWidth(s2)) > mx do
         s2 := Copy(s2, 1, Length(s2)-1);
      SCanvas.TextOut(x, y, s2);
      y := y + SCanvas.TextHeight(s2);
      i := i + 1;
   end;
end;

{ This routine is called before each print job.  For simple print jobs,
simply create a TPageInfo object and set the title.  See the Multipage
example for a more complex BeginPrint routine }

procedure TTestForm.PrintPreview1BeginPrint(var Info: TPageInfo);
begin
   Info := TPageInfo.Create;
   Info.Title := 'Text Example';
end;

{ This routine is used for any clean up after all pages have been
printed/previewed }

procedure TTestForm.PrintPreview1EndPrint(var Info: TPageInfo);
begin
   Info.Free;
   Info := NIL;
end;

procedure TTestForm.Font1ButClick(Sender: TObject);
begin
   FontDialog1.Execute;
end;

procedure TTestForm.Preview1ButClick(Sender: TObject);
begin
   PrintPreview1.PrintPreview;         { Its so easy to do Print Preview! }
end;

procedure TTestForm.PrinterSetup1Click(Sender: TObject);
begin
   PrinterSetupDialog1.Execute;
end;

procedure TTestForm.Exit1Click(Sender: TObject);
begin
   Close;
end;

procedure TTestForm.Preview2ButClick(Sender: TObject);
begin
   { First set the printer orientation }
   if PortraitBut.Checked then Printer.orientation := poPortrait;
   if LandscapeBut.Checked then Printer.orientation := poLandscape;
   PrintPreview2.PrintPreview;
   Printer.Orientation := poPortrait;
end;

{ Table example - this example simply fills in cells with text and numbers,
and draws borders around the cells.  A Thicker border is drawn around the
entire table. Note the formula used below for determining pen widths }

procedure TTestForm.PrintPreview2PrintPage(var Info: TPageInfo;
  SCanvas: TSpecialCanvas);
var
   NumRow : integer;
   NumCol : integer;
   x, y   : integer;
   i, j   : integer;
   s      : string;
   dx, dy : integer;
   oy, ox : integer;
begin
   NumCol := StrToInt(NumColEdit.Text);
   NumRow := StrToInt(NumRowEdit.Text);
   Info.LastPage := True;

   SCanvas.Font := FontDialog2.Font;
   dx := SCanvas.TextWidth(' Cell 99, 99 X');

   { Center a Large Title }
   SCanvas.Font.Size := SCanvas.Font.Size * 2;
   y := SCanvas.YInch(1);
   s := 'Table Example';
   x := SCanvas.PageWidth div 2 - SCanvas.TextWidth(s) div 2;
   SCanvas.TextOut(x,y, s);
   SCanvas.Font.Size := SCanvas.Font.Size div 2;

   { Draw the Table }
   SCanvas.Pen.Width := ROUND(0.5 * SCanvas.Xres / 72);     { a 0.5 point Line Width }
   SCanvas.Brush.Style := bsSolid;
   SCanvas.Brush.Color := clWhite;
   oy := SCanvas.YInch(2);
   y  := oy;
   for j := 1 to NumRow do begin
      ox := SCanvas.PageWidth div 2 - (dx * NumCol) div 2;
      x  := ox;
      dy := SCanvas.TextHeight('X');
      for i := 1 to NumCol do begin
         SCanvas.Rectangle(x, y, x+dx, y + dy);
         s := ' Cell ' + IntToStr(i) + ', ' + IntToStr(j) + ' ';
         SCanvas.TextOut(x,y, s);
         x := x + dx;
      end;
      y := y + dy;
   end;
   SCanvas.Pen.Width := 2 * SCanvas.Xres div 72;     { a 3 point Line Width }
   SCanvas.Brush.Style := bsClear;
   SCanvas.Rectangle(ox, oy, x, y);

end;

procedure TTestForm.Button3Click(Sender: TObject);
begin
   if OpenDialog1.Execute then
      Image1.Picture.LoadFromFile(OpenDialog1.FileName);
end;

{ Graphic example - This example stretches a bitmap graphic to various sizes
on the page.  The display doesn't look great on a 256 color adapter, but the
printed output looks on an HP4 at 600 dpi. }

procedure TTestForm.PrintPreview3PrintPage(var Info: TPageInfo;
  SCanvas: TSpecialCanvas);
var
   R      : TRect;
   w, h   : integer;
   nw, nh : integer;
begin
   Info.LastPage := True;
   with SCanvas do begin
      w := Image1.Picture.Bitmap.Width;
      h := Image1.Picture.Bitmap.Height;
      nw := Xinch(6.5);
      nh := Yinch(6.5 * h / w);
      R := Rect(XInch(1), YInch(3), XInch(1)+nw, YInch(3)+nh);
      StretchDraw(R, Image1.Picture.Bitmap);
      Pen.Width := 2 * SCanvas.Xres div 72;     { a 3 point Line Width }
      Brush.Style := bsClear;
      Rectangle(XInch(1), YInch(3), XInch(1)+nw, YInch(3)+nh);

      w := Image1.Picture.Bitmap.Width;
      h := Image1.Picture.Bitmap.Height;
      nw := Xinch(2);
      nh := Yinch(2 * h / w);
      R := Rect(XInch(3.25), YInch(1), XInch(3.25)+nw, YInch(1)+nh);
      StretchDraw(R, Image1.Picture.Bitmap);
      Pen.Width := 2 * SCanvas.Xres div 72;     { a 3 point Line Width }
      Brush.Style := bsClear;
      Rectangle(XInch(3.25), YInch(1), XInch(3.25)+nw, YInch(1)+nh);
   end;
end;

procedure TTestForm.Preview3ButClick(Sender: TObject);
begin
   PrintPreview3.PrintPreview;
end;

procedure TTestForm.PrintPreview2BeginPrint(var Info: TPageInfo);
begin
   Info := TPageInfo.Create;
   Info.Title := 'Table Example';
end;

procedure TTestForm.PrintPreview3BeginPrint(var Info: TPageInfo);
begin
   Info := TPageInfo.Create;
   Info.Title := 'Graphic Example';
end;

procedure TTestForm.LoadTextButClick(Sender: TObject);
begin
   if OpenDialog2.Execute then
      FileMemo.Lines.LoadFromFile(OpenDialog2.FileName);
end;

procedure TTestForm.FontButClick(Sender: TObject);
begin
   FontDialog3.Execute;
end;

{ TNEWPageInfo is used to extend TPageInfo }
{ You can add complex pagination information if you want }

type
   TNEWPageInfo = class(TPageInfo)
   public
      TopLine     : array[1..999] of integer;  { Line Number at the top of each Page      }
      NumPaginate : integer;                   { How many pages have been paginated       }
      CanPrint    : boolean;                   { True = Printing, False = Paginating      }
      OrigPage    : integer;                   { Page to print, but hasn't been paginated }
   end;

procedure TTestForm.PrintPreview4BeginPrint(var Info: TPageInfo);
begin
   Info := TNEWPageInfo.Create;                { Use the NEW PageInfo object instead }
   Info.Title := 'MultiPage example';
   (Info as TNEWPageInfo).NumPaginate := 1;
   (Info as TNEWPageInfo).CanPrint    := True;
end;

{ MultiPage example - this routine shows how to print multiple pages with
EFFICIENT pagination.  Pages are only paginated when they are needed.
It is a generic routine that can be applied to any pagination scheme. }

procedure TTestForm.PrintPreview4PrintPage(var Info: TPageInfo;
  SCanvas: TSpecialCanvas);
var
   NEWInfo : TNEWPageInfo;
   Line1   : integer;
   x, y    : integer;
   i       : integer;
   s       : string;
begin
   NEWInfo := Info as TNEWPageInfo;

   { *** CHECK PAGINATION FIRST *** }

   { Note:  This Pagination scheme allows OUT OF ORDER print requests }
   { For example, the user can print pages 15-20 without breaking the routine }
   if NEWInfo.CurPage = 1 then
      { No pagination needed if on the first page }
      Line1 := 0                              { Memo.Lines is zero based }
   else
      if NEWInfo.NumPaginate >= NEWInfo.CurPage then
         { Page has already been paginated }
         Line1 := NEWInfo.TopLine[NEWInfo.CurPage]
      else begin
         { Need to do some extra pagination }
         NEWInfo.CanPrint := False;
         NEWInfo.OrigPage := NEWInfo.CurPage;
         for i := NEWInfo.NumPaginate to NEWInfo.CurPage do begin
            NEWInfo.CurPage := i;
            PrintPreview4PrintPage(Info {really NEWInfo}, SCanvas);
         end;
         NEWInfo.CanPrint := True;
         NEWInfo.CurPage := NEWInfo.OrigPage;
         Line1 := NEWInfo.TopLine[NEWInfo.CurPage];
      end;

   { *** ACTUAL PRINTING / PAGINATION *** }

   { Print a title line:  Title, Page, Date }
   if NEWInfo.CanPrint then with SCanvas do begin
      Font := FontDialog3.Font;
      Font.Size  := 14;
      Font.Style := Font.Style + [fsBold, fsItalic];
      y := Yinch(1);
      TextOut(Xinch(1), y, 'Multi-Page Example');

      s := 'Page ' + IntToStr(NEWInfo.CurPage);
      TextOut(PageWidth div 2 - TextWidth(s) div 2, y, s);

      s := FormatDateTime('d mmmm yyyy', Now);
      TextOut(PageWidth - Xinch(1) - TextWidth(s), y, s);
   end;

   x := SCanvas.Xinch(1);
   y := SCanvas.Yinch(1.5);

   SCanvas.Font := FontDialog3.Font;

   { Print out each line of text }
   while (y + SCanvas.TextHeight('X') < (SCanvas.PageHeight - SCanvas.Yinch(1)))
      and (Line1 <= FileMemo.Lines.Count-1) do begin
      if NEWInfo.CanPrint then SCanvas.TextOut(x, y, FileMemo.Lines[Line1]);
      Line1 := Line1 + 1;
      y := y + SCanvas.TextHeight('X');
   end;

   { Check if we're the last page }
   if Line1 > FileMemo.Lines.Count-1 then begin
      NEWInfo.LastPage := True;
   end else
      NEWInfo.LastPage := False;

   { Set some pagination variables }
   NEWInfo.TopLine[NEWInfo.CurPage+1] := Line1;
   if NEWInfo.NumPaginate < NEWInfo.CurPage + 1 then
      NEWInfo.NumPaginate := NEWInfo.CurPage + 1;
end;

procedure TTestForm.Preview4ButClick(Sender: TObject);
begin
   PrintPreview4.CurrentPage := StrToInt(StartPageEdit.Text);
   PrintPreview4.PrintPreview;
end;

end.

