unit Testem;

{ Program copyright (c) 1995 by Charles Calvert }
{ Project Name: RUNDLL }

{ RunDLL is an excerpt from Delphi Programming Unleashed, a SAMS book. }

{ This is an example program showing how to create and call DLLs in Delphi.
  
  This program will test FRACTDLL and APIDLL. FRACTDLL has Delphi forms
  stored in it, APIDLL, creates windows by directly calling
  the Windows API.

  You must compile and link FRACTDLL and APIDLL before
  running this program. }

interface

uses
  SysUtils, WinTypes, WinProcs,
  Messages, Classes, Graphics,
  Controls, Forms, Dialogs,
  StdCtrls, DLLUnit, Buttons;

type
  TBigNumber = class(TForm)
    CreateChild: TBitBtn;
    AboutDLL: TBitBtn;
    Pictures: TBitBtn;
    Fern: TBitBtn;
    Squares: TBitBtn;
    Start: TBitBtn;
    RegPopup: TBitBtn;
    CreatePopup: TBitBtn;
    procedure StartClick(Sender: TObject);
    procedure PicturesClick(Sender: TObject);
    procedure AboutDLLClick(Sender: TObject);
    procedure CreateChildClick(Sender: TObject);
    procedure RegPopupClick(Sender: TObject);
    procedure CreatePopupClick(Sender: TObject);
  private
    DLLWnd: HWnd;
  end;

var
  BigNumber: TBigNumber;

implementation

{$R *.DFM}

{ Call Delphi forms stored in a DLL }
procedure TBigNumber.PicturesClick(Sender: TObject);
begin
  case (Sender as TBitBtn).Tag of
    100: ShowPictures(Application.Handle);
    101: ShowSquares(Application.Handle);
    102: ShowFerns(Application.Handle);
  end;
end;

{ Show the About Box from the APIDLL }
procedure TBigNumber.AboutDLLClick(Sender: TObject);
begin
  ShowAbout(Handle);
end;

{ This routine registers and shows a child window. It
  can only be called once during the run of the program.
  It calls routines from APIDLL.}
procedure TBigNumber.StartClick(Sender: TObject);
begin
  RegisterChild(Handle);
  Start.Enabled := False;
end;

{ This routine creates and runs a child window
  It calls routines from APIDLL}
procedure TBigNumber.CreateChildClick(Sender: TObject);
begin
  DLLUnit.CreateChild(Handle);
end;

{ This routine registers and shows a Popup window. It
  can only be called once during the run of the program.
  It calls routines from APIDLL. }
procedure TBigNumber.RegPopupClick(Sender: TObject);
begin
  RegisterWinPopup;
  RegPopup.Enabled := False;
end;

{ Create a popup window. Calls APIDLL }
procedure TBigNumber.CreatePopupClick(Sender: TObject);
begin
  CreateWinPopup;
end;

end.
