unit Fern;

{ Program copyright (c) 1995 by Charles Calvert }
{ Project Name: RUNDLL }

interface

uses
  SysUtils, WinTypes, WinProcs,
  Messages, Classes, Graphics,
  Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TDAry = array[0..3] of Double;

  TFerns = class(TForm)
    Timer1: TTimer;
    procedure FormResize(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    MaxX, MaxY: Integer;
    MaxIterations, Count: INteger;
    x, y: Double;
  public
    { Public declarations }
    procedure DoPaint;
  end;

const
  a: TDAry = (0, 0.85, 0.2, -0.15);
  b: TDAry = (0, 0.04, -0.26, 0.28);
  c: TDary = (0, -0.04, 0.23, 0.26);
  d: TDAry = (0.16, 0.85, 0.22, 0.24);
  e: TDAry = (0, 0, 0, 0);
  f: TDAry = (0, 1.6, 1.6, 0.44);

var
  Ferns: TFerns;

procedure ShowFerns(Handle: THandle); export;

implementation

{$R *.DFM}

procedure ShowFerns(Handle: THandle);
begin
  Application.Handle := Handle;
  Ferns := TFerns.Create(Application);
  try
    Ferns.ShowModal;
  finally
    Ferns.Free;
  end;
end;

procedure TFerns.DoPaint;
var
  PaintDC: HDC;
  K: Integer;
  TempX, TempY: Double;
begin
  k := Random(100);
  if ((k > 0) and (k <= 85)) then  k := 1;
  if ((K > 85) and (K <= 92)) then k := 2;
  if (k > 92) then K := 3;
  TempX := a[k] * x + b[k] * y + e[k];
  TempY := c[k] * x + d[k] * y + f[k];
  x := TempX;
  y := TempY;
  if ((Count >= MaxIterations) or (Count <> 0)) then
    Canvas.Pixels[Round(x * MaxY / 11 + MaxX / 2),
                  Round(y * - MaxY / 11 + MaxY)] :=  clGreen;
  Count := Count + 1;
end;

procedure TFerns.FormResize(Sender: TObject);
begin
  MaxX := Width;
  MaxY := Height;
  MaxIterations := MaxY * 50;
end;

procedure TFerns.Timer1Timer(Sender: TObject);
var
  i: Integer;
begin
  if Count > MaxIterations then begin
    Invalidate;
    Count := 0;
  end;

  for i := 0 to 200 do
    DoPaint;
end;

procedure TFerns.FormCreate(Sender: TObject);
begin
  Count := 0;
  x := 0;
  y := 0;
end;

end.
