// bmpvivw.cpp : implementation of the CBmpViewView class
// -- Williams

#include "stdafx.h"
#include "bmpview.h"

#include "bmpvidoc.h"
#include "bmpvivw.h"
#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////
// CBmpViewView

IMPLEMENT_DYNCREATE(CBmpViewView, CScrollView)

BEGIN_MESSAGE_MAP(CBmpViewView, CScrollView)
        //{{AFX_MSG_MAP(CBmpViewView)
        ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
        //}}AFX_MSG_MAP
/* User-defined palette change message */
        ON_MESSAGE(WM_PALCHANGE,OnPalChange)
        ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
        ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
        END_MESSAGE_MAP()

/////////////////////////////////////////////////
// CBmpViewView construction/destruction

CBmpViewView::CBmpViewView()
{
}

CBmpViewView::~CBmpViewView()
{
}

/////////////////////////////////////////////////
// CBmpViewView drawing

void CBmpViewView::OnDraw(CDC* pDC)
{
        CBmpViewDoc* pDoc = GetDocument();
        ASSERT_VALID(pDoc);
        CPalette *pal;
/* Get CDIB from document */
        CDib *dib=pDoc->GetDIB();
        CRect r(0,0,(int)dib->Width(),(int)dib->Height());
        pal=dib->GetPalette();
/* Paint it! */
        dib->Paint(pDC,&r,&r,pal);
}

BOOL CBmpViewView::OnPreparePrinting(CPrintInfo* pInfo)
{
        // default preparation
        return DoPreparePrinting(pInfo);
}


/* We override printing so we can do custom scaling */
void CBmpViewView::OnPrint(CDC* pDC,CPrintInfo *pinfo)
{
/* This code is almost identical to OnDraw
   except we pass CDib::Paint two rectangles so
   it will scale */
        CBmpViewDoc* pDoc = GetDocument();
        ASSERT_VALID(pDoc);
        CPalette *pal;
        CDib *dib=pDoc->GetDIB();
        CRect r(0,0,(int)dib->Width(),(int)dib->Height());
        CRect pr=pinfo->m_rectDraw;
/* Compute scaling factors */
        int scalex=pr.right/r.right;
        int scaley=pr.bottom/r.bottom;
        // try to optimize scaling
/* If drawing is smaller than printed page... */
        if (scalex!=0&&scaley!=0)
          {
/* Scale by smallest factor */
          int scale=min(scalex,scaley);
          pr.right=r.right*scale;
          pr.bottom=r.bottom*scale;
          }
        pal=dib->GetPalette();
        dib->Paint(pDC,&pr,&r,pal);
}

void CBmpViewView::OnInitialUpdate(void)
  {
  CBmpViewDoc* pDoc=GetDocument();
  CDib *dib=pDoc->GetDIB();
  CSize sz;
// Set scroll sizes for scroll view
  dib->GetSize(sz);
  SetScrollSizes(MM_TEXT,sz);
// don't allow the window to be larger than the BMP at 1st
  GetParentFrame()->RecalcLayout();
  ResizeParentToFit();
  }

/* Fix palette on activation */
void CBmpViewView::OnActivateView(BOOL act,
  CView *view,CView *dview)
  {
  CScrollView::OnActivateView(act,view,dview);
  if (act)
    OnPalChange((WPARAM)m_hWnd,0); // same as WM_PALCHANGE
  }


/////////////////////////////////////////////////
// CBmpViewView diagnostics

#ifdef _DEBUG
void CBmpViewView::AssertValid() const
{
        CScrollView::AssertValid();
}

void CBmpViewView::Dump(CDumpContext& dc) const
{
        CScrollView::Dump(dc);
}

// non-debug version is inline
CBmpViewDoc* CBmpViewView::GetDocument()
{
 ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CBmpViewDoc)));
 return (CBmpViewDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////
// CBmpViewView message handlers

// Copy file to cliboard
void CBmpViewView::OnEditCopy()
{
         CBmpViewDoc* pDoc=GetDocument();
         if (OpenClipboard())
           {
           BeginWaitCursor();
           EmptyClipboard();
           SetClipboardData(CF_DIB,pDoc->GetDIB()->GetHDIBCopy());
           CloseClipboard();
           EndWaitCursor();
           }

}


// Handle WM_PALCHANGE (user message)
LONG CBmpViewView::OnPalChange(WPARAM wParam,LPARAM lParam)
  {
  CBmpViewDoc* pDoc = GetDocument();
  if (pDoc->GetDIB()->GetHDIB() == NULL)
        return 0L;  // must be a new document

  CPalette* pPal = pDoc->GetDIB()->GetPalette();
  if (pPal != NULL)
    {
    CMainFrame* pAppFrame =
      (CMainFrame*) AfxGetApp()->m_pMainWnd;
    ASSERT(pAppFrame->IsKindOf(RUNTIME_CLASS(CMainFrame)));

    CClientDC appDC(pAppFrame);
      // All views but one should be a background palette.
      // wParam contains a handle to the active view,
      // so the SelectPalette bForceBackground flag is
      // FALSE only if wParam == m_hWnd (this view)
    CPalette* oldPalette =
      appDC.SelectPalette(pPal,((HWND)wParam)!= m_hWnd);

    if (oldPalette != NULL)
      {
      // see if colors changed
      UINT nColorsChanged = appDC.RealizePalette();
      if (nColorsChanged > 0)
        pDoc->UpdateAllViews(NULL);  // yep, fix everyone
      appDC.SelectPalette(oldPalette, TRUE);
      }
    }


   return 0L;
   }

