{--------------------------------------------------}
{                   SpiroMania                     }
{          SPINFORM.PAS : Main Form Unit           }
{            By Jeff Duntemann KG7JF               }
{                                                  }
{ The main form unit for a cycloid curve generator }
{ functionally similar to the old SpiroGraph toy.  }
{ Written for *The Delphi Programming Explorer*    }
{ Copyright (c) 1995 The Coriolis Group, Inc.      }
{              Last Updated 3/9/95                 }
{--------------------------------------------------}

unit Spinform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Printers,
  Spinner, Buttons, ColorGrd, Spin, ExtCtrls;

type
  TForm1 = class(TForm)
    ButtonPanel: TPanel;
    ClearButton: TButton;
    SpinButton: TButton;
    PrintButton: TButton;
    QuitButton: TButton;
    ColorGrid1: TColorGrid;
    SpinA: TSpinEdit;
    SpinB: TSpinEdit;
    SpinD: TSpinEdit;
    SpinALabel: TLabel;
    SpinBLabel: TLabel;
    SpinDLabel: TLabel;
    PickPrinterButton: TButton;
    PrinterSetupDialog1: TPrinterSetupDialog;
    procedure QuitButtonClick(Sender: TObject);
    procedure SpinButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure PrintButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure PickPrinterButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

var
  CanvasIsClear : Boolean;   { Flags when pattern needs to be regenned }
                             { from within the Paint method.           }

{$R *.DFM}

procedure TForm1.QuitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.SpinButtonClick(Sender: TObject);

VAR
  CenterX,CenterY : Integer;

begin
  CanvasIsClear := False;
  CenterY := ClientHeight DIV 2;
  CenterX := (ClientWidth DIV 2) + (ButtonPanel.Width DIV 2);
  Canvas.Pixels[CenterX,CenterY] := CLBlack;
  SpinWheels(Canvas,SpinA.Value,SpinB.Value,SpinD.Value,
             CenterX,CenterY,ColorGrid1.ForegroundColor);
end;

procedure TForm1.ClearButtonClick(Sender: TObject);

begin
  CanvasIsClear := True; { Canvas is clear; don't repaint pattern on Paint }
  Refresh;
end;

{ Printing may seem complex, but it's really only a matter of using  }
{ a scaling factor with SpinWheels and passing the printer canvas    }
{ to SpinWheels as a parameter.  SpinWheels is executed between the  }
{ BeginDoc/EndDoc pair...and that's it!                              }
procedure TForm1.PrintButtonClick(Sender: TObject);

VAR
  CenterX,CenterY : Integer;
  ScaleFactor     : Integer;
  SpinAText,SpinBText,SpinDText,LabelText : String;

begin
  WITH Printer DO
    BEGIN
      { Calculate a scale factor, which is the ratio of the shortest }
      { dimension of the printed page to the shortest dimension of   }
      { the displayed form canvas: }
      ScaleFactor := PageWidth DIV ClientHeight;
      CenterX := PageWidth DIV 2;
      CenterY := PageHeight DIV 2;
      BeginDoc;
      { We spin the wheels again on the printer canvas, generating   }
      { the same pattern shown on the form, only scaled to fill the  }
      { same portion of the printer canvas:                          }
      SpinWheels(Printer.Canvas,
                 SpinA.Value*ScaleFactor,
                 SpinB.Value*ScaleFactor,
                 SpinD.Value*ScaleFactor,
                 CenterX,CenterY,ClBlack);
      { Create the label for the printed sheet: }
      LabelText := 'A='+IntToStr(SpinA.Value)+
                '   B='+IntToStr(SpinB.Value)+
                '   D='+IntToStr(SpinD.Value);
      { We're re-using CenterX and CenterY here to position the label }
      { that displays the spin parameters on the printed sheet:       }
      CenterY := Trunc(PageHeight - (PageHeight * 0.07));
      CenterX := (PageWidth - Canvas.TextWidth(LabelText)) DIV 2;
      Canvas.TextOut(CenterX,CenterY,LabelText);
      EndDoc;
    END;
end;

{ We only need to set the default values once for the cycloid pattern, }
{ so this is done when the form is created:                            }
procedure TForm1.FormCreate(Sender: TObject);
begin
  SpinA.Value := 200;
  SpinB.Value := 70;
  SpinD.Value := 65
end;

{ All the real action happens when the form is redrawn.  Each time that }
{ happens, the pattern is regenerated using SpinWheels:                 }
procedure TForm1.FormPaint(Sender: TObject);

VAR
  CenterX,CenterY : Integer;

begin
   IF NOT CanvasIsClear THEN
    BEGIN
      CenterY := ClientHeight DIV 2;
      CenterX := (ClientWidth DIV 2) + (ButtonPanel.Width DIV 2);
      Canvas.Pixels[CenterX,CenterY] := CLBlack;
      SpinWheels(Canvas,SpinA.Value,SpinB.Value,SpinD.Value,
                 CenterX,CenterY,ColorGrid1.ForegroundColor);
    END;
end;

{ This is all it takes to run the Printer Setup dialog box.  It's really }
{ all done by Windows:                                                   }
procedure TForm1.PickPrinterButtonClick(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

end.
