//---------------------------------------------------------------------------
//
//	File:			PALETTE.CPP
//	Programmer: 	Bob Provencher
//	Create Date:	11/15/94
//	Last Mod Date:	3/5/95
//	Description:	Palette class implementation
//
//	Copyright (c) 1994, 1995. Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#include "palette.h"

extern BOOL fDump;

#define MAX_STEPS	( 1 << ( sizeof( BYTE ) * 8 ) )

BOOL Palette::EasyFadeTo( const LogPalette& pal )
{
	BOOL fDone = FALSE;
	LogIdPalette logIdPal( pal );
    dbugstream debug;
	if ( fDump )
	{
    	debug << "Target identity palette.\r\n";
		debug << pal;
	}
	UINT stat = LogSystemPalette::GetUse() == SYSPAL_STATIC ? 20 : 2;
	for ( int i = 0; i < MAX_STEPS && !fDone; i++ )
		fDone = EasyStepTo( logIdPal, stat );
	logPal = logIdPal;
	return fDone;
}

BOOL Palette::EvenFadeTo( const LogPalette& pal )
{
	LogIdPalette logIdPal( pal );
	LogPalette   savPal( logPal );
	UINT stat = LogSystemPalette::GetUse() == SYSPAL_STATIC ? 20 : 2;
	PaletteStep* step = new PaletteStep[ logPal.Size() ];
	logPal.ComputeFadeSteps( logIdPal, step, 128 );
	for ( int i = 0; i < 127; i++ )
	{
		logPal.EvenStepTo( savPal, step, i );
		Animate( stat / 2, logPal.Size() - stat, logPal );
	}
	Animate( stat / 2, logPal.Size() - stat, logIdPal );
	logPal = logIdPal;
	delete [] step;
	return TRUE;
}
