//    EXAMPLE PROGRAM FOR 16BIT 3D SPRITE PUTTING
//
//-----------------------------------------------------
//
//S. Christian Flowers, LYRIXX@aol.com - September 1995
//
//
// Draws sprites as vertical columns for use in raycasting
// engines. See drawobject() on how to place your z buffer
// information.
//
//
//3d coords are normally x,y,z
//This method uses a 2D xy to track each object
//and "h" for the height of the object. So that...
//
//        obj.x = 3d_x
//        obj.y = 3d_z
//        obj.h = 3d_y   <<< +3d_y is up and 0 is ground level
//
//The player is ALWAYS assumed to be at 0,0 faceing +Y
//if you were looking top down. This means
//topdown -X is screen RIGHT and +X is screen LEFT.
//
//               -Y            (behind player)
//
//              (0,0)
//      -X        .      +X    ( . = eye of player at 0,0 - faceing +Y)
//               /|\
//              / | \
//             / +Y  \         (in front of player)
//            /   |   \
// (screen right) |  (screen left)  <<<<backwards, because faceing +Y
//          /     |     \
//         /      |      \
//        /       V       \ (viewcone)
//
//This means if you do a 2D rotation flip the X
//result before sending the object to be drawn.
//
//           //Rotate the object 2D
//           newx = (obj.x*cos(a))-(obj.y*sin(a));
//           newy = (obj.x*sin(a))+(obj.y*cos(a));
//
//           //Translate the object
//           newx+=px-(worldx/2);
//           newy+=py-(worldy/2);
//
//           if newy is < 0 object would be behind player
//
//           newx=-newx;  //flip x value before projecting
//                        //because we face +Y topdown which
//								  //makes the Xs backwards
//
//           sx=(newx*DTS)/newy;  //newy serves as 3d z distance
//           sy=(obj.h*DTS)/newy; //h serves as 3d y coord
//
// DTS would be distance from player's eye to the screen
//
//SOURCE THAT IS NOT INCLUDE!!!!!!!!!!!!!
//---------------------------------------
//This program used PCX routines from "Flights of Fantasy"
//I'm not authorized to pass those on so you'll need
//your own PCX routines.
//
//Also, set320(), settext(), copy(), and get() are from
//my own 16 bit routines and those are not included because
//everyone "should" have similar routines.
//
//************ DISTRIBUTE FREELY, ENJOY *************
// Use at your own risk. Don't blame me for nothin'!!!
//
//These routines are not fully optimized. And are kinda slow,
//but not _too_ bad. I've been programming 32Bit and
//I've forgotten how slow 16Bit can be.
//
//You could make a few tables to save a few divisions
//Along with other things.
//All routines are in C/C++...no ASM sorry, I simply don't know ASM.
//
//I kept them like this to ease porting into your code
//and to make it easier for all to understand.
//Also everyone has their own optimizing techniques
//I didn't want to take it too far so you can do it "your" way.
//
//If anyone re-writes drawobject() to inline ASM please send
//me a copy. Thanks in advance!
//
//The word "tile" refers to a 64X64 bitmap image
//
//I tried to comment as much as possible. Still if
//you have questions or see something "stupid" I overlooked
//E-mail mail me at LYRIXX@aol.com
//
#define Uni unsigned
#define ucharf unsigned char far
#define uchar unsigned char

#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <mem.h>
#include <math.h>
#include "grafx16.h" //my stuff        B.Y.O.C.
#include "pcx.h"     //FOF routines
#include "screen.h"  //FOF routines

unsigned char *buffer=new unsigned char[64000];  //work buffer
unsigned char *buffer2=new unsigned char[64000]; //holds background pcx
unsigned char far *screen; //points to the screen to display results

////////////////////////object structure///////////////////
struct object_type{

  long x,y;         //2d world coords of an object
  //long newx,newy; //to hold rotated & translated object
  long h;           //height of object... cacadaemons anyone?
  int tnum;         //current tile in use by an object
  //....
  //....weapon,health,status,ect...
  //....
};

//////////////////////object bank structure/////////////////
struct object_bank{

	int numobjects;   //number of objects in bank
	object_type *obj; //will point to current object structure

	int numtiles;     //number of images (64X64) in tile bank
	unsigned char **t;//tile bank used by objects: views,alive,dead,etc...

};


///////////////PROTOTYPES///////////////////////
void load(ucharf *pcxname,ucharf *buf,int pal);  //loads a pcx file
void alloc_object_tiles(int num,object_bank *ob);//allocs tile bank
void alloc_objects(int num,object_bank *ob);     //allocs objects
void loadobjects(object_bank *ob);               //Lame Loader
void drawobject(int num,object_bank *ob);        //draws 1 object
void drawobjects(object_bank *ob);               //sorts and calls drawobj

////////////////////////////////////////////////////////
//"Flights of Fantasy's" 16Bit PCX stuff
//Hint: if you're useing FOF routines, go and add
//      a "delete pcxbuf.image" in his pcx routines
//      It was a bug. It keeps allocating a 64K buffer
//      each time you load a pcx! ouch!
//      Try loading 7 or 8 pcxs you'll see what happens.
////////////////////////////////////////////////////////
pcx_struct pcxbuf;  // Buffer for PCX data
Pcx pcxloader;      // PCX loader object

//////////////////////////////////
//CONSTANTS FOR FIXED POINT OPPS//
//////////////////////////////////
const SHIFT = 10;
const SHIFT_MULT=1<<SHIFT;
//////////////////////////////////


int DTS=160;     //distance from eye to screen used in 3D projections
int pheight=128; //what would be player's height or the floor height
					  //Note: 0 is ground level and up is positive.

object_bank objbank1; //declare 1 object bank structure for use

//SCREEN VIEWPORT VALUES USED TO CLIP OBJECT TO VIEWPORT
//You could make a structure out of these
int XMIN=0;    //0
int XMAX=319;  //319
int YMIN=0;    //0
int YMAX=199;  //199

int SXOFF=159; //screen x viewport offset for projecting
int SYOFF=99;  //screen y viewport offset for projecting


void main(){

	int i,j;
	unsigned char key;

	screen=(char far *)MK_FP(0xa000,0);//set pointer to video mem

	set320();                          //set screen mode

	//ALLOCATE THE MEM FOR OBJECTS
	alloc_object_tiles(9,&objbank1);   //alloc 9 tiles to the tile bank
	alloc_objects(4,&objbank1);        //alloc 4 objects to the object bank

	loadobjects(&objbank1);  //suckass "by-hand" loader for demo

	load("obj16bg.pcx",buffer2,0); //load background pcx in background buffer

	clear(buffer,0);    //start clean

	//Adjust viewport settings
	XMIN=1;
	XMAX=319;
	YMIN=1;
	YMAX=184;

	int num=0; //current user selected object number

	int val;   //User sees a white flash when selecting a new
				  //object this holds original tile number temporary

///////////////////////////////////////////////////////
//MAIN LOOP
///////////////////////////////////////////////////////
do{

 copy(buffer2,buffer,64000); //copy in a fresh background image

 drawobjects(&objbank1);     //sort & draw objects

 copy(buffer,screen,64000);  //display results, no video blank checking


 if(kbhit()){key=getch();               //fetch a key via SLOW!!!!

 //SELECT NEW OBJECT
 if(key==' '){num++; if(num>3){num=0;}    //cycle through objects
				  val=objbank1.obj[num].tnum; //hold tile number in use
				  objbank1.obj[num].tnum=8;   //switch it to solid white
				  copy(buffer2,buffer,64000); //draw "flash" for..
				  drawobjects(&objbank1);     //..visual reference
				  copy(buffer,screen,64000);
				  objbank1.obj[num].tnum=val; //switch it back to original
				  }
 //MOVE CURRENT OBJECT
 if(key=='1'){objbank1.obj[num].x+=4;}  //right
 if(key=='2'){objbank1.obj[num].x-=4;}  //left
 if(key=='3'){objbank1.obj[num].y+=4;}  //far
 if(key=='4'){objbank1.obj[num].y-=4;}  //near
 if(key=='5'){objbank1.obj[num].h+=4;}  //Up : ajust current object's height
 if(key=='6'){objbank1.obj[num].h-=4;   //Down
				 //Note:  128 is "ground level"  for object center
				 if(objbank1.obj[num].h<128){objbank1.obj[num].h=128;}
				 }

 if(key=='t'){objbank1.obj[num].tnum++;  //change tile used by current object
				  if(objbank1.obj[num].tnum>7){objbank1.obj[num].tnum=0;}
				  }

  }

 }while(key!=27); //if ESC exit


 settext(); //restore text mode upon exit

return;
}
/////////////////////////////////////////////
//Sorts and Draws objects: Jiffy Routines, Inc.
//
//Note: this sorts ALL objects -y and +y
//
//Objects with -y just get skipped
//////////////////////////////////////////////
void drawobjects(object_bank *ob){

 int i;

 //You should make these arrays global
 unsigned char *sort=new unsigned char[ob->numobjects];
 int *list=new int[ob->numobjects];
 unsigned char *order=new unsigned char[ob->numobjects];


 //clear sort table
 for(i=0;i<ob->numobjects;i++){

 sort[i]=0;            //clear sort table
 list[i]=ob->obj[i].y; //store object y value of objects

 }

 //sort far to near
 int val=0;
 int d=0;
 int j;

 //Not the greatest sorter but it works

 for(i=0;i<ob->numobjects;i++){

	  d=-16834; //set way behind user. set d=0; if -y's have been weeded

	  for(j=0;j<ob->numobjects;j++){  //find furthest object

		if(!(sort[j])){ //if sort j not 0  skip it

				if(list[j]>=d){d=list[j]; val=j;}  //track progress

				 }

	  }//j

	  order[i]=val; //store number of object
	  sort[val]=1;  //tag it to be skipped in next inner loop

  }//i



//DRAW THEM
//Note if an object has a -y value drawobject() will skip it
 for(i=0;i<ob->numobjects;i++){ //loop through objects

	drawobject(order[i],ob);     //draw 1

 }

 delete sort;  //destroy the arrays
 delete list;
 delete order;

 return;
}
//////////////////////////////////////////////
//DRAWOBECT( )
//Draws 1 object(2d sprite)
//"num" is the object to draw
//ASSUMES object is 256X256 and tile is 64X64
//
//Could be modified to handle any size image
//The 16bit fixed point would need changing too
//
//If you rewrite to inline ASM please E-Mail
//a copy thanx! LYRIXX@aol.com
//////////////////////////////////////////////
void drawobject(int num,object_bank *ob){

  //So we don't have to keep going through ob to get to the object
  object_type obj1=ob->obj[num]; //pass the pointer to hold this object
											//so it a little more readable

  if(obj1.y<1){return;} //behind the player?

  //Assume, for now bottom is 128 units down from center
  int bot=128; //128 is 256/2
  int top,left,right;

  bot=(bot*DTS)/obj1.y;   //Project bottom, note: could be tabled for speed
  top=-bot;               //Assume the rest because
  left=-bot;              //the sprite is a perfect square
  right=bot;

  //PROJECT OBEJECT CENTER TO SCREEN
  //Note: I didn't flip X here because I handed loaded the objects
  long cx=(obj1.x*DTS)/obj1.y;           //project object center x
		 cx+=SXOFF;                        //offset viewport x
  long cy=((pheight-obj1.h)*DTS)/obj1.y; //project object center y
		 cy+=SYOFF;                        //offset viewport y

  //Now offset bot,top,left,right to cx,cy
  //Then before any more time is waisted, do a visabilty check
  bot+=cy;   if(bot<YMIN){return;}  //above screen
  top+=cy;   if(top>YMAX){return;}  //below screen
  left+=cx;  if(left>XMAX){return;} //off screen to the right
  right+=cx; if(right<XMIN){return;}//off screen to the left

  int span=(right-left)+1;//set span of the width: bot-top could be used too

  //compute scale (64X64) and convert to fixed point
  //Should table these values for speed
  int scale=(int)((64.000/(float)(span))*SHIFT_MULT);

  //or if you want to remove the span variable
  //int scale=(int)((64.000/(float)((right-left)+1))*SHIFT_MULT);


  int tx=0; int ty=0; //holds fixed point values to scale texture
  int resety=ty;      //used to reset ty before each column is drawn

  //CLIP THE OBJECT
  //clip left edge?
  if(left<XMIN){tx=(XMIN-left)*scale; //step into texture...DON'T SHIFT YET!!!
					 left=XMIN;            //set left to left edge of viewport
					}
  //clip right?
  if(right>XMAX){right=XMAX;}         //set to right edge

  //clip top edge?
  if(top<YMIN){resety=(YMIN-top)*scale;//step into texture...DON'T SHIFT YET!!!
					top=YMIN;               //set top to top edge of viewport
				  }
  //clip bottom?
  if(bot>YMAX){bot=YMAX;}              //set to bottm edge


////Finally, DRAW OBJECT

  unsigned char y,c; //where in the texture column we are & color
  unsigned char *t=ob->t[obj1.tnum]; //set up pointer to object's tile

  unsigned char *bleft=buffer+(top*320+left); //pointers to screen buffer
  unsigned char *bbot=buffer+(bot*320+left); //for the outer loop
  unsigned char *bright=buffer+(top*320+right);

  unsigned char *b,*bend;//pointers buffer for inner loop

  unsigned char *tp; //tile offset pointer. points to current column
							//in texture

  for( ;bleft<bright;bleft++,bbot++){ //SPAN WIDTH OF OBJECT

			tp=t+((63-((tx>>SHIFT)&63))<<6);//offset tile pointer to column
													  //AND by 63 to avoid bugs

			ty=resety; //reset y to top

			b=bleft;   //point to top of column in buffer
			bend=bbot; //point to bottom of column in buffer

	 // if(obj1.y<zbuf[screenx]){ //uncomment for zbuf checking
											//note: screenx would be screen x column
											//looping variables left to right
											//zbuf[320] would contain distance
											//to each wall at this screen x

	 //Also if a tile does not use all the columns in the tile
	 //you could add a scheme to skip those too.
	 //like if(obj1.t[num].table[ "0 - 63" ]==1){ // skip // }

	  for( ;b<bend;b+=320){ //DRAW 1 COLUMN

			y=(ty>>SHIFT)&63; //get position in texture column

			c=*(tp+y);        //get color of pixel

			if(c){*(b)=c;}    //if not transparent pixel draw it

			ty+=scale;        //step to next position in texture column

	  }//inner loop

	  //}//zbuf (see above comments)

		tx+=scale;
  }//outer loop

 return;
}
//////////////////////
//LOADOBJECTS( )
//Jiffy Routines, Inc.
///////////////////////
void loadobjects(object_bank *ob){


  //Use your own PCX load here and load 8 64X64 tiles
	load("obj16.pcx",buffer,1);

	//grab the 8 tiles & putthem in the tile bank
	//...I'll take the long road here for easier reading.
	//NOTE: all tiles are stored 90 degrees COUNTER clockwise
	get(0,0,buffer,ob->t[0],64,64);   //monster 1
	get(64,0,buffer,ob->t[1],64,64);  //monster 2
	get(128,0,buffer,ob->t[2],64,64); //stone column
	get(192,0,buffer,ob->t[3],64,64); //battle axe
	get(0,64,buffer,ob->t[4],64,64);  //sword 1
	get(64,64,buffer,ob->t[5],64,64); //sword 2
	get(128,64,buffer,ob->t[6],64,64);//sword 3
	get(192,64,buffer,ob->t[7],64,64);//tree

	int i;//set up solid white tile for "flash" when user selects an object
	for(i=0;i<4096;i++){ob->t[8][i]=1;} //fill tile 8 solid white

	//Now we'll initialize 8 objects in view on 2d +y side
	int n=0;
	ob->obj[n].x=-620; ob->obj[n].y=800;   //object 0
	ob->obj[n].h=128;	 ob->obj[n].tnum=n;

	n++;
	ob->obj[n].x=720; ob->obj[n].y=750;    //object 1
	ob->obj[n].h=128;	 ob->obj[n].tnum=n;

	n++;
	ob->obj[n].x=-120; ob->obj[n].y=700;    //object 2
	ob->obj[n].h=128;	 ob->obj[n].tnum=n;

	n++;
	ob->obj[n].x=120; ob->obj[n].y=600;     //object 3
	ob->obj[n].h=128;	 ob->obj[n].tnum=n;

 return;
}

////////////////////////////////////////////////
//ALLOC_OBJECT_TILES( )
//
//Allocs memory for "num" tiles for objects
//ASSUMES TILES ARE 64X64 = 4096 BYTES EACH!!!!
////////////////////////////////////////////////
void alloc_object_tiles(int num,object_bank *ob){

 int i;

 ob->t=new unsigned char*[num];       //set number of tile pointers

 for(i=0;i<num;i++){

	 ob->t[i]=new unsigned char[4096]; //alloc 1 tile
 }

 ob->numtiles=num; //store how many tiles are in tile bank

 return;
}
//////////////////////////////////////////////
//ALLOC_OBJECTS( )
//
//Allocates memeory for "num" objects
//////////////////////////////////////////////
void alloc_objects(int num,object_bank *ob){

	ob->obj=new object_type[num];  //alloc object structurs
	ob->numobjects=num;            //store number of object in bank

 return;
}
//////////////////////////////////////////////
//Loads a PCX File
//////////////////////////////////////////////
void load(ucharf *pcxname,ucharf *buf,int pal){

	pcxloader.load(pcxname,&pcxbuf);

	if(pal==1){	setpalette(pcxbuf.palette); }

	copy(pcxbuf.image,buf,64000);

return;
}

//******* END OF FILE *******

