PROGRAM ShowRandomGnomes; { "Gnomes" are pithy sayings, aphorisms, etc. }
{$M 8192,0,0}  { 8k stack, no heap needed }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

USES DOS, CRT;
CONST
  Space = #32;  { my simple ways of minimizing typing errors }
  Hyphen = #45;
  NL = #13#10;

VAR
  MaxWidth : BYTE;
  Bar : STRING;
  AppendNumbers: BOOLEAN;
  NumWidth : BYTE;

PROCEDURE ShowHelp (problem : BYTE);
{----
 If any *foreseen* errors arise, we are sent
  here to give a little help and exit (relatively) peacefully
----}
VAR
  message : STRING [79];
BEGIN
  NormVideo;
  WriteLn ('GNOMES v1.10 - Free DOS thing: random tagline displayer.');
  WriteLn ('October 18, 1995. Copyright (c) 1995 by David Daniel Anderson - Reign Ware.'+NL);
  WriteLn ('Usage: GNOMES [tag_file] [/s (Single tag)] [/a (Append numbers)'+NL);
  WriteLn ('Note:  Read GNOMES.DOC for details.'+NL);
  IF (problem > 0) THEN BEGIN
    CASE (problem) OF
      7 : message := 'Error opening or closing the gnomes text file.';
      ELSE message := 'Unknown error.';
    END;
    WriteLn ('Error encountered:'); WriteLn (message);
  END;
  Halt (problem);
END;

PROCEDURE CheckIO;
BEGIN
  IF IOResult <> 0 THEN ShowHelp (7);
END;

PROCEDURE UpFast (VAR Str: STRING);  {** from SWAG **}
INLINE ($8C/$DA/$5E/$1F/$FC/$AC/$30/$E4/$89/$C1/$E3/$12/$BB/Ord('a')/Ord('z')/
        $AC/$38/$D8/$72/$08/$38/$F8/$77/$04/$80/$6C/$FF/$20/$E2/$F1/$8E/$DA);

FUNCTION Upper (lstr : STRING): STRING;
BEGIN
  upfast (lstr);
  Upper := lstr;
END;

FUNCTION RTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [Length (InStr)] IN [#0, #9, #32]) DO
    Dec (InStr [0]);
  RTrim := InStr;
END;

FUNCTION LTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [1] IN [#0, #9, #32]) DO
    Delete (InStr, 1, 1);
  LTrim := InStr;
END;

FUNCTION Trim (InStr: STRING): STRING;
BEGIN
  Trim := RTrim (LTrim (InStr));
END;

PROCEDURE GetCursor (VAR csize : INTEGER);
CONST
  videoio = $0010;
  getcur  = $0300;
VAR
  regs : REGISTERS;
BEGIN
  regs. AX := getcur;
  Intr (videoio, regs);
  csize := regs. CX;     { upper scan line }
END;

PROCEDURE SetCursor (csize : INTEGER);
CONST
  videoio = $0010;
  cshape  =     1;
VAR
  regs : REGISTERS;
BEGIN
  regs. CX := csize;
  regs. AH := cshape;
  Intr (videoio, regs);
END;

FUNCTION IsFile (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) <> Directory)
    THEN IsFile := TRUE
    ELSE IsFile := FALSE;
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PSTR;
  IF jPath = '' THEN jPath := '*.*';
  IF (NOT (jPath [Length (jPath)] IN [':', '\'])) AND IsDir (jPath) THEN
    jPath := jPath + '\';
  IF (jPath [Length (jPath)] IN [':', '\']) THEN
    jPath := jPath + '*.*';

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir + jName+ jExt;

  sDir := jDir;
  GetFilePath := jPath;
END;

PROCEDURE Setup (VAR gnomes : TEXT; VAR NumLines : LONGINT; VAR lone : BOOLEAN);
VAR
  PSTR,
  gpath  : PATHSTR;
  gdir   : DIRSTR;
  gname  : NAMESTR;
  gext   : EXTSTR;
  pindex : BYTE;
  scrncols  : BYTE ABSOLUTE $0040:$004a; {from Lou Duchez, found in SWAG}
BEGIN
  MaxWidth := scrncols-1;
  Bar [0] := Chr (MaxWidth);
  FillChar (Bar [1], MaxWidth, #196);  {Bar and MaxWidth are global vars}

  gpath := '';
  lone := FALSE;
  AppendNumbers := FALSE;

  FOR pindex := 1 TO ParamCount DO
  BEGIN
    PSTR := Upper (ParamStr (pindex));
    IF (PSTR = '/S') THEN
    BEGIN
      WriteLn;
      lone := TRUE;
    END
    ELSE IF (PSTR = '/A') THEN
      AppendNumbers := TRUE
    ELSE
      gpath := PSTR;
  END;

  IF (gpath = '') and IsFile ('GNOMES.TXT') THEN
    gpath := 'GNOMES.TXT';

  IF (gpath = '') THEN
  BEGIN
    FSplit (FExpand (ParamStr (0)), gdir, gname, gext);
    gpath := gdir + 'GNOMES.TXT';
  END
  ELSE
    gpath := GetFilePath (gpath, gdir);

  Assign (gnomes, gpath);
  Reset (gnomes); CheckIO;
  NumLines := 0;
  WHILE NOT EoF (gnomes) DO
  BEGIN
    ReadLn (gnomes);
    Inc (NumLines);
  END;
  Reset (gnomes);

  IF AppendNumbers THEN
  BEGIN
    Str (NumLines, PSTR);  { reuse PSTR variable to conserve stack }
    NumWidth := Length (PSTR);
  END;
END;

FUNCTION lZero (w : WORD) : STRING;
VAR
  s : STRING;
BEGIN
  Str (w: 0, s);
  IF Length (s) = 1 THEN
    s := '0' + s;
  lZero := s;
END;

PROCEDURE WriteDateTime;      {called by DisplayGnome to write system time.}
CONST
  sti = 'System time is:  ';
VAR
  h, m, s, d : WORD;
BEGIN
  GetTime (h, m, s, d);
  WriteLn (sti : MaxWidth - 8, lZero (h), ':', lZero (m), ':', lZero (s));
END;

FUNCTION wrapline (theline : STRING) : STRING;
{---- Split line after MaxWidth or nearest preceding Space ----}
VAR
  parta, partb : STRING;     { first and second part of line }
  breakchar    : CHAR;       { character at which line is split }
  breakfound   : BOOLEAN;
  breakpos     : BYTE;
BEGIN
  breakpos   := MaxWidth + 2;
  breakfound := FALSE;

  {! Search for a Space or a Hyphen or the ASCII 255 non-displaying char, }
  {! by decrementing the breakpos while checking validity. }

  WHILE ((NOT breakfound) AND (breakpos > 2)) DO
  BEGIN
    Dec (breakpos);
    breakfound := theline [breakpos] IN [Space, Hyphen, #255];
  END;
  IF NOT breakfound {if unable to find a valid breakpoint, break at max width}
    THEN breakpos := MaxWidth + 1;

  parta     := Copy (theline, 1, breakpos - 1);
  partb     := Copy (theline, breakpos + 1, Length (theline) - (breakpos));
  breakchar := theline [breakpos];

  IF NOT (breakchar IN [Space, #255]) THEN {save non-blank breakchar}
    IF breakpos <= MaxWidth
      THEN parta := parta + breakchar
      ELSE partb := breakchar + partb;

  {! Write out the first part, and then return the second part. }

  WriteLn (parta);
  wrapline := Trim (partb);
END;

PROCEDURE DisplayGnome (VAR gnomes : TEXT; TotalLines : LONGINT; lone : BOOLEAN);
VAR
  count,
  gnome_numb  : INTEGER;
  gnome       : STRING;
  number      : STRING [10];
BEGIN
  IF NOT lone THEN
  BEGIN
    TextAttr := Succ (TextAttr);
    IF (TextAttr = 15) THEN
    BEGIN
      WriteDateTime;
      WriteLn (Bar);
      TextAttr := 9;
    END;
  END;
  gnome_numb := 1 + Random (TotalLines);

  Reset (gnomes);
  count := 0;
  REPEAT
    ReadLn (gnomes, gnome);
    Inc (count);
  UNTIL (count = gnome_numb) OR EoF (gnomes);

  IF AppendNumbers THEN
  BEGIN
    Str (gnome_numb: NumWidth, number);
    gnome := number + ': ' + gnome;
  END;
  WHILE (Length (gnome) > MaxWidth) DO
    gnome := wrapline (gnome);
  WriteLn (gnome);

  IF (NOT lone) THEN BEGIN
    WriteLn (Bar);
    FOR Count := 1 TO 40 DO
      IF NOT KeyPressed THEN
        Delay (95);
  END;
END;

VAR
  GnomeFile : TEXT;
  NumLines  : LONGINT;
  Done,
  JustOne   : BOOLEAN;
  KP        : CHAR;
  Cursor    : INTEGER;

BEGIN
  Setup (GnomeFile, NumLines, JustOne);

  IF (NOT JustOne) THEN
  BEGIN
    GetCursor (Cursor);     { Read current cursor size }
    SetCursor ($2000);      { Turn cursor off }
    TextAttr := 8;
    ClrScr;
  END;

  Randomize;
  Done := FALSE;
  REPEAT
    DisplayGnome (GnomeFile, NumLines, JustOne);
    IF KeyPressed THEN
    BEGIN
      KP := ReadKey;
      IF KP <> #32 THEN Done := TRUE;
      IF KP = #0 THEN KP := ReadKey;  { Read extended keys one more time }
    END;
  UNTIL (Done OR JustOne);

  Close (GnomeFile);
  IF (NOT JustOne) THEN
  BEGIN
    NormVideo;
    SetCursor (Cursor);     { Restore cursor to whatever it was }
  END;
END.
