unit TestEini;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, EIniFile, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    Label1: TLabel;
    Edit1: TEdit;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    procedure Button1Click(Sender: TObject);
    procedure	FillListBox;
    function	GetName : string;
    procedure FormCreate(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
	AddLine,
  RepLine,
  DelLine,
  About;

var
  Section	: string;
  Line		: string;
  Msg			: string;
  CurDir	: string;



function	TForm1.GetName : string;
var
	winDir	: array[0..127] of char;
begin
	{ Get filename }
  Result	:= Edit1.Text;

  { Check to see if it has a full path. If not then assume windows directory }
	if Pos('\',Result) = 0 then
   	begin
	    GetWindowsDirectory( winDir, 127 );
   		Result	:= StrPas( winDir );
	    Result	:= Result + '\' + Edit1.Text;
		end;
end;

procedure	TForm1.FillListBox;
var
	Name		: string;
  Line		: string;
 	iniFile	: System.text;

begin
	{ Clear the list }
	ListBox1.Clear;

  { Get the name }
  Name	:= GetName;

  try
	 	{ Point to the file and open it }
  	AssignFile( iniFile, Name );
		Reset( iniFile );

	  repeat
		 	{ Read a line }
			readln( iniFile, Line );

	    { Add to the list box }
	    ListBox1.Items.Add(Line);
		until	eof(iniFile);

    { Done with the file }
  	CloseFile(iniFile);
	except
  	on E:EInOutError do MessageDlg( 'Error handling .INI file: '+E.Message, mtError, [mbOK], 0 );
  end;
end;


procedure TForm1.Button1Click(Sender: TObject);
var
	LocIni	: TEIniFile;
	Search	: string;
begin
	LocIni	:= TEIniFile.Create( Edit1.Text );

  Search	:= '';

	if InputQuery( 'Search', 'Search text', Search ) then
  	begin
		  if LocIni.ItemExists( Search, Section, Line ) then
	  	begin
  	  	Msg	:= 'Found it! '+'Section: ['+Section+'] Line: '+Line;
		  	MessageDlg( Msg, mtConfirmation, [mbOK], 0 );
			end
		else
  		MessageDlg( 'Not found!', mtConfirmation, [mbOK], 0 );
    end;

	{ Done with .INI }
	LocIni.Free;

  { Re-show the listbox }
  FillListBox;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	Edit1.Text	:= CurDir + '\TMPSYS.INI';
	FillListBox;
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
	FillListBox;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
	LocIni	: TEIniFile;
	AddThis	: string;
begin
	LocIni	:= TEIniFile.Create( Edit1.Text );

	{ Prompt for the section and line }
  if BtnBottomDlg.ShowModal=mrOk then
  	begin
		  if LocIni.AddItem( BtnBottomDlg.Edit1.Text, BtnBottomDlg.Edit2.Text ) then
      	begin
        	FillListBox;
			  	MessageDlg( 'Added new line!', mtConfirmation, [mbOK], 0 );
				end;
    end;

	{ Done with .INI }
	LocIni.Free;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
	LocIni	: TEIniFile;
	RepThis	: string;
begin
	LocIni	:= TEIniFile.Create( Edit1.Text );

	{ Prompt for the section and line }
  if BtnBottomDlg1.ShowModal=mrOk then
  	begin
		  if LocIni.ReplaceItem( BtnBottomDlg1.Edit2.Text, BtnBottomDlg1.Edit1.Text, BtnBottomDlg1.Edit3.Text ) then
      	begin
        	FillListBox;
			  	MessageDlg( 'Replaced line!', mtConfirmation, [mbOK], 0 );
				end;
    end;

	{ Done with .INI }
	LocIni.Free;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
	LocIni	: TEIniFile;
	AddThis	: string;
begin
	LocIni	:= TEIniFile.Create( Edit1.Text );

	{ Prompt for the section and line }
  if BtnBottomDlg2.ShowModal=mrOk then
  	begin
		  if LocIni.DeleteItem( BtnBottomDlg2.Edit2.Text, BtnBottomDlg2.Edit1.Text ) then
      	begin
        	FillListBox;
			  	MessageDlg( 'Deleted line!', mtConfirmation, [mbOK], 0 );
				end;
    end;

	{ Done with .INI }
	LocIni.Free;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
	AboutBox.ShowModal;
end;

begin
	{ Get current directory }
  GetDir(0,CurDir);
end.

