// midifdlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CMidifitzDlg dialog
#include "midiin.h"
#include "midiout.h"

const CString ApplTitle = "MIDI Fitz";

struct midiChord {
	unsigned char note[4];
	unsigned char root;
	BOOL major;
	BOOL minor;
	BOOL seventh;
	BOOL diminished;
	BOOL augmented;
	BOOL major7;
	int operator!=(midiChord& crd);
};

const int MaxTempo = 280;

class CMidifitzDlg : public CDialog
{
	// --- pointers to midi devices
	MidiIn *pMidiIn;
	MidiOut *pMidiOut;
	// --- pointers to dialog controls
	CComboBox* pPianoList;
	CComboBox* pBassList;
	CScrollBar* pPianoVolume;
	CScrollBar* pBassVolume;

	// --- radio buttons; can't map with DDX/DDV
	CButton* pExternalButton;
	CButton* pInternalButton;
	CButton* p34Time;
	CButton* p44Time;
	// --- using DDV with value, can't map control for enable
	CEdit* pTempo;

	BOOL playing;
	BOOL onAutoPilot;
	BOOL inLastChorus;
	BOOL Tagging;
	BOOL stopping;
	BOOL notesdown[88];
	midiChord chord;
	midiChord lastchord;
	short int measure;
	short int barcount;
	short int measurecnt;
	// ---- .INI file settings
	int& pianovoice;
	int& bassvoice;
	int& bassvelocity;
	int& pianovelocity;
	int& outputdevice;
	BOOL& leadin;
	BOOL& isExternal;
	BOOL& autopilot;
	// ---
	short int countoff;
	short int lastnote;
	short int clock;
	short int beat;
	UINT timer;
	DWORD prevtime;
	// --- arrays for remembering arrangement as played 1st chorus
	static midiChord chordmemory[128];
	short int chordctr;
	short int getchordctr;

// private functions
	midiChord FindChord();
	LONG OnMIDIMessage(WPARAM, LPARAM msg);
	void BuildChord(CString& cstr, const midiChord& cord);
	void ControllerChange(short unsigned note, short unsigned velocity);
	void NoteOn(short unsigned note, short unsigned velocity);
	void StartMsg();
	void TimingMsg();
	void StopMsg();
	void AdjustTempo();
	void BassLine();
	void PickBass();
	void PlayBassNote(int beat, int third);
	void InitializeSong();
	void ComputeExternalTempo();
	void LastNoteOff();
	friend void CALLBACK TimerCallback(UINT, UINT, DWORD, DWORD, DWORD);
// Construction
public:
	CMidifitzDlg(int& pvoice, int& pvol, int& bvoice, int& bvol,
					int& odev, BOOL& syn, BOOL& ldin, BOOL& autp);
// Destruction
	~CMidifitzDlg();

// Dialog Data
	//{{AFX_DATA(CMidifitzDlg)
	enum { IDD = IDD_MIDIFITZ_DIALOG };
	CComboBox	m_cOutDevice;
	CButton	m_bLeadin;
	CButton	m_bHalfTime;
	CStatic	m_ctlMeasure;
	CStatic	m_ctlBeat;
	CStatic	m_ctlChord;
	CButton	m_bAutopilot;
	CButton	m_bStartStop;
	CButton	m_bLastChorus;
	CButton	m_bTag;
	UINT	m_nTempo;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMidifitzDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CMidifitzDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnSelchangePiano();
	afx_msg void OnSelchangeBass();
	afx_msg void OnSelchangeOutdevice();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKillfocusTempo();
	afx_msg void OnInternal();
	afx_msg void OnExternal();
	afx_msg void OnStartstop();
	afx_msg void OnAutopilot();
	afx_msg void OnLastchorus();
	afx_msg void OnTag();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnLeadin();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
