// midifdlg.cpp : implementation file
//

#include "stdafx.h"
#include "midifitz.h"
#include "midifdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

inline UINT tmpo2ms(UINT tmpo)
{
	UINT ms = 1000 / (((tmpo) * 24) / 60);
	return ms;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg message handlers

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	
	// TODO: Add extra about dlg initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
// CMidifitzDlg dialog

midiChord CMidifitzDlg::chordmemory[128];

CMidifitzDlg::CMidifitzDlg(int& pvoice, int& pvol, int& bvoice, int& bvol,
					int& odev, BOOL& syn, BOOL& ldin, BOOL& autp)
	: CDialog(CMidifitzDlg::IDD, NULL),
		pianovoice(pvoice), pianovelocity(pvol), 
		bassvoice(bvoice), bassvelocity(bvol),
		outputdevice(odev),
		leadin(ldin), isExternal(syn), autopilot(autp)
{
	//{{AFX_DATA_INIT(CMidifitzDlg)
	m_nTempo = 120;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	// ---- initialize midi data
	pMidiIn = 0;
	pMidiOut = 0;
	for (int i = 0; i < 88; i++)
		notesdown[i] = FALSE;
	timeBeginPeriod(tmpo2ms(MaxTempo));
	InitializeSong();
}

void CMidifitzDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMidifitzDlg)
	DDX_Control(pDX, IDC_OUTDEVICE, m_cOutDevice);
	DDX_Control(pDX, IDC_LEADIN, m_bLeadin);
	DDX_Control(pDX, IDC_HALFTIME, m_bHalfTime);
	DDX_Control(pDX, IDC_MEASURE, m_ctlMeasure);
	DDX_Control(pDX, IDC_BEAT, m_ctlBeat);
	DDX_Control(pDX, IDC_CHORD, m_ctlChord);
	DDX_Control(pDX, IDC_AUTOPILOT, m_bAutopilot);
	DDX_Control(pDX, IDC_STARTSTOP, m_bStartStop);
	DDX_Control(pDX, IDC_LASTCHORUS, m_bLastChorus);
	DDX_Control(pDX, IDC_TAG, m_bTag);
	DDX_Text(pDX, IDC_TEMPO, m_nTempo);
	DDV_MinMaxUInt(pDX, m_nTempo, 32, 280);
	//}}AFX_DATA_MAP
}

void CMidifitzDlg::InitializeSong()
{
	midiChord crd = {{0,0,0,0},0,0,0,0,0,0};
	chord = lastchord = crd;
	beat = 0;
	playing = FALSE;
	lastnote = 0;
	clock = 0;
	countoff = 0;
	timer = 0;
	prevtime = 0;
	measure = 0;
	measurecnt = 0;
	barcount = 0;
	onAutoPilot = FALSE;
	inLastChorus = FALSE;
	Tagging = FALSE;
	stopping = FALSE;
	for (short int i = 0; i < 128; i++)
		chordmemory[1] = crd;
	chordctr = 0;
	getchordctr = 0;
}

CMidifitzDlg::~CMidifitzDlg()
{
	timeEndPeriod(tmpo2ms(MaxTempo));
	delete pMidiOut;
	delete pMidiIn;	
}

BEGIN_MESSAGE_MAP(CMidifitzDlg, CDialog)
	//{{AFX_MSG_MAP(CMidifitzDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_CBN_SELCHANGE(IDC_PIANO, OnSelchangePiano)
	ON_CBN_SELCHANGE(IDC_BASS, OnSelchangeBass)
	ON_CBN_SELCHANGE(IDC_OUTDEVICE, OnSelchangeOutdevice)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_EN_KILLFOCUS(IDC_TEMPO, OnKillfocusTempo)
	ON_BN_CLICKED(IDC_INTERNAL, OnInternal)
	ON_BN_CLICKED(IDC_EXTERNAL, OnExternal)
	ON_BN_CLICKED(IDC_STARTSTOP, OnStartstop)
	ON_BN_CLICKED(IDC_AUTOPILOT, OnAutopilot)
	ON_BN_CLICKED(IDC_LASTCHORUS, OnLastchorus)
	ON_BN_CLICKED(IDC_TAG, OnTag)
	ON_MESSAGE(MM_MIM_DATA, OnMIDIMessage)
	ON_BN_CLICKED(IDC_LEADIN, OnLeadin)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMidifitzDlg message handlers

BOOL CMidifitzDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}
	
	// TODO: Add extra initialization here
	pMidiIn = new MidiIn(m_hWnd);
	pMidiOut = new MidiOut(outputdevice);
	
	pPianoList = (CComboBox*)GetDlgItem(IDC_PIANO);
	ASSERT(pPianoList != 0);

	pBassList = (CComboBox*)GetDlgItem(IDC_BASS);
	ASSERT(pBassList != 0);

	pPianoVolume = (CScrollBar*)GetDlgItem(IDC_PIANOVOLUME);
	ASSERT(pPianoVolume != 0);

	pBassVolume = (CScrollBar*)GetDlgItem(IDC_BASSVOLUME);
	ASSERT(pBassVolume != 0);

	pExternalButton = (CButton*)GetDlgItem(IDC_EXTERNAL);
	ASSERT(pExternalButton != 0);

	pInternalButton = (CButton*)GetDlgItem(IDC_INTERNAL);
	ASSERT(pInternalButton != 0);

	pTempo = (CEdit*)GetDlgItem(IDC_TEMPO);
	ASSERT(pTempo != 0);

	p34Time = (CButton*)GetDlgItem(IDC_THREEFOUR);
	ASSERT(p34Time != 0);

	p44Time = (CButton*)GetDlgItem(IDC_FOURFOUR);
	ASSERT(p44Time != 0);

	pMidiOut->DeviceList(&m_cOutDevice);
	pMidiOut->SetPatch(1, bassvoice);
	if (pianovoice)
		pMidiOut->SetPatch(0, pianovoice-1);

	pPianoVolume->EnableScrollBar(pianovoice ? 
				ESB_ENABLE_BOTH : ESB_DISABLE_BOTH);
	m_cOutDevice.SetCurSel(outputdevice);
	pPianoList->SetCurSel(pianovoice);
	pBassList->SetCurSel(bassvoice-32);
	pPianoVolume->SetScrollRange(0, 63);
	pPianoVolume->SetScrollPos(pianovelocity);
	pBassVolume->SetScrollRange(0, 63);
	pBassVolume->SetScrollPos(bassvelocity);
	pExternalButton->SetCheck(isExternal);
	pInternalButton->SetCheck(!isExternal);
	p44Time->SetCheck(1);
	m_bLeadin.SetCheck(leadin);
	m_bHalfTime.SetCheck(1);
	m_bAutopilot.SetCheck(autopilot);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMidifitzDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMidifitzDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMidifitzDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

int midiChord::operator!=(midiChord& crd)
{
	return  root       != crd.root       ||
			minor      != crd.minor      ||
			seventh    != crd.seventh    ||
			diminished != crd.diminished ||
			augmented  != crd.augmented  ||
			major7     != crd.major7;
}

midiChord CMidifitzDlg::FindChord()
{
	static midiChord voicings[] = {
//         notes     root major  minor   7th    dim    aug   MAJ7
// major
		{{1, 4, 6, 9}, 9, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE},
// 7th
		{{1, 4, 7, 9}, 9, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
		{{1, 4, 6,10}, 6, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
		{{1, 3, 7,10}, 3, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
		{{1, 5, 8,11}, 1, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
		{{1, 5, 7,11}, 1, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE}, // flat-5
// min7
		{{1, 4, 8,11}, 1, FALSE, TRUE,  TRUE,  FALSE, FALSE, FALSE},
		{{1, 4, 7,11}, 1, FALSE, TRUE,  TRUE,  FALSE, FALSE, FALSE},
		{{1, 8,11,16}, 1, FALSE, TRUE,  TRUE,  FALSE, FALSE, FALSE},
		{{1, 8,16,23}, 1, FALSE, TRUE,  TRUE,  FALSE, FALSE, FALSE},
// maj7
		{{1, 5, 8,12}, 1, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE },
// major
		{{1, 5, 8},    1, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE},
		{{1, 8,17},    1, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE},
		{{1, 3,17},    1, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE},
		{{1, 4, 9},    9, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE},
		{{1, 6,10},    6, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE},
// minor
		{{1, 4, 8},    1, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE},
		{{1, 5,10},   10, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE},
		{{1, 8,16},    1, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE},
		{{1, 6, 9},    6, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE},
// dim
		{{1, 4, 7},    1, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE},
		{{1, 7,10},    1, FALSE, FALSE, FALSE, TRUE,  FALSE, FALSE},
// aug
		{{1, 5, 9},    1, FALSE, FALSE, FALSE, FALSE, TRUE,  FALSE},
// min7
		{{1, 4,11},    1, FALSE, TRUE,  TRUE,  FALSE, FALSE, FALSE},
		{{1,11,16},    1, FALSE, TRUE,  TRUE,  FALSE, FALSE, FALSE},
// maj7
		{{1, 5,12},    1, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE },
		{{1, 8,12},    1, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE },
// 7th
		{{1, 7, 9},    9, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
		{{1, 7,11},    9, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
		{{1, 5,11},    1, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
		{{1, 8,11},    1, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
		{{1, 7,12},    3, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
// major
		{{1, 5},       1, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE},
		{{1, 8},       1, TRUE,  FALSE, FALSE, FALSE, FALSE, FALSE},
// minor
		{{1, 4},       1, FALSE, TRUE,  FALSE, FALSE, FALSE, FALSE},
// maj7
		{{1,12},       1, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE },
// 7th
		{{1,11},       1, TRUE,  FALSE, TRUE,  FALSE, FALSE, FALSE},
	};
	midiChord crd = {{0},0};
	// --- collect the bottom 4 notes
	short int nct = 0;
	unsigned char lowest = 0;
	for (short int i = 0; i < 88 && nct < 4; i++)	{
		if (notesdown[i])	{
			if (!lowest)
				lowest = i+1;
			unsigned char nt = (i-(lowest-1))+1;
			// --- remove octaves
			for (short int j = 0; j < nct; j++)
				if ((nt % 12) == (crd.note[j] % 12))
					break;
			if (j == nct)
				crd.note[nct++] = nt;
		}
	}
	// --- compress the notes into a tightly-voiced chord
	for (i = 0; i < nct-1; i++)
		while (crd.note[i+1] > crd.note[i]+12)
			crd.note[i+1] -= 12;
	// ----- search the table of voicings
	for (short int j = 0; j < sizeof(voicings)/sizeof(midiChord); j++)	{
		for (short int k = 0; k < 4; k++)	{
			if (voicings[j].note[k] && crd.note[k] != voicings[j].note[k])
				break;
		}
		if (k == 4)	{
			// ---- found a voicing
			crd = voicings[j];
			crd.root = (((lowest-1 + voicings[j].root)-1) % 12)+1;
			if (crd.major || crd.major7)	{
				// --- look for 3rd or 10th
				for (i = 1; i < 4; i++)
					if (crd.note[i] == 5 || crd.note[i] == 17)
						break;
				if (i == 4 && crd.root == chord.root)
					// --- no 3rd or 10th & same root,
					//        use minor from prev chord
					crd.minor = chord.minor;
			}
			// --- major or minor w/no 7th inherits prev 7th if same root
			if ((crd.major || crd.minor) && !crd.seventh)
				if (crd.root == chord.root)
					crd.seventh = chord.seventh;
			return crd;
		}
	}
	return chord;
}

void CMidifitzDlg::BuildChord(CString& cstr, const midiChord& cord)
{
	if (cord.root == 0)	{
		cstr = "";
		return;
	}
    static char *notes[] = {
		"A", "Bb","B", "C", "Db","D",
   		"Eb","E", "F", "F#","G", "Ab"
	};
	cstr = notes[cord.root-1];
	if (cord.major7)
		cstr += "maj7";
	else if (cord.diminished)
		cstr += "dim";
	else if (cord.augmented)
		cstr += "aug";
	else	{
		if (cord.minor)
			cstr += "min";
		if (cord.seventh)
			cstr += "7";
	}
}

inline void CMidifitzDlg::ControllerChange(short unsigned note,
							short unsigned velocity)
{
	if (pianovoice != 0)
		pMidiOut->Pedal(0, note, velocity);
}
inline void CMidifitzDlg::NoteOn(short unsigned note,
							short unsigned velocity)
{
	BOOL down = velocity != 0;
	if (pianovoice != 0)
		pMidiOut->NoteOn(0, note, 
			down ? ((velocity + pianovelocity*2) / 2) : 0);
		notesdown[note-21] = down;
	if (down)	{
		midiChord cord = FindChord();
		if (cord != chord)	{
			chord = cord;
			if (!onAutoPilot)	{
				CString sChord;
				BuildChord(sChord, chord);
				m_ctlChord.SetWindowText(sChord);
			}
		}
	}
}

inline void CMidifitzDlg::StartMsg()
{
	if (!playing)	{
		if (!isExternal)
			pMidiOut->StartMessage();
		InitializeSong();
		clock = 23;
		playing = TRUE;
		countoff = (m_bLeadin.GetCheck() == 1)   ? 
				   ((p44Time->GetCheck() == 1) ? 8 : 6) : 0;
		pInternalButton->EnableWindow(FALSE);
		pExternalButton->EnableWindow(FALSE);
		p34Time->EnableWindow(FALSE);
		p44Time->EnableWindow(FALSE);
		m_bAutopilot.EnableWindow(FALSE);
	}
}

// ------ bass lines for 2 chord types
const int measures = 8;
static short int lines[][measures][4][3] = {
	// --- major & minor
	{{ {1},    {5}, {6}, {7}},
	 { {8,0,8},{6}, {5}, {3}},
	 { {1}, {3}, {5}, {8}}, 
	 { {1}, {8}, {5}, {8,5,3}},
	 { {17},  {16},{15},{14}},
	 {{13,8,5},{3}, {1},{-5}},
	 { {1},{13}, {8}, {5,0,-5}},
	 { {1}, {3}, {5}, {8}}},
	// --- 7th, augmented, diminished, & minor 7th
	{{ {1},    {5}, {6}, {7}},
	 { {8,0,8},{6}, {5}, {3}},
	 { {1},{-2},{-5},{-8}},
	 { {1}, {3}, {5}, {8}},
	 {{13}, {8}, {5}, {8}},
	 { {1},{-2},{-5},{-8}},
	 { {17},  {16},{15},{14}},
	 {{13,8,5},{3}, {1},{-5}}}
};
static short int tagline[][4][3] = {
	{{13},{13},{12},{12}}, {{11},{11},   {10},{10}},
	{ {3}, {5}, {6}, {7}}, { {8},{-5},   {-3},{-1}},
	{{13}, {5}, {6}, {7}}, { {8},{-5,-1}, {1}, {1}}
};
static short int chrd;
// ------ play a bass note on the beat
void CMidifitzDlg::PlayBassNote(int bt, int third)
{
	// --- get the root of the current chord
	lastnote = lastchord.root + 31;
	// -- build a chord offset into the lines table
	chrd = 0;
	if (lastchord.seventh || lastchord.augmented || lastchord.diminished)
		chrd = 1;
	short int relative;
	// --- select a relative (to root) note to play
	if (m_bHalfTime.GetCheck() == 0 ||
					(m_bAutopilot.GetCheck() == 1 && 
						(barcount > 15 && barcount < 24)))
		// --- playing in 4, use bass line table
		relative = lines[chrd][measure][bt][third];
	else
		// --- playing in 2, alternate root and dominant
		relative = (bt == 0 ? 1 : ((measure & 1) ? 8 : -5));
	// --- adjust 3rd for minor or diminished
	if ((lastchord.minor || lastchord.diminished) && (relative == 5 || relative == -8))
		--relative;
	// --- adjust 5th and 7th for diminished
	if (lastchord.diminished &&
		(relative == -5 || relative == 8) || relative == 11 || relative == -2)
		--relative;
	// --- adjust 5th for augmented
	if (lastchord.augmented && (relative == 8 || relative == -5))
		relative++;
	// --- adjust relative to preserve relative zero in lines table
	if (relative < 0)
		++relative;
	lastnote += relative;
	// --- adjust note to within reasonable bass range
	if (lastnote < 22)
		lastnote += 12;
	if (lastnote > 56)
		lastnote -= 12;
	// --- play the note
	pMidiOut->NoteOn(1, lastnote, bassvelocity*2);
}

inline void CMidifitzDlg::BassLine()
{
	short int relative;

	if (onAutoPilot)	{
		if (getchordctr < 128)	{
			lastchord = chordmemory[getchordctr];
			CString sChord;
			BuildChord(sChord, lastchord);
			m_ctlChord.SetWindowText(sChord);
		}
		if (++getchordctr == (Tagging ? 144 : 128))
			getchordctr = 0;
		if (inLastChorus)	{
			if (getchordctr == 0)	{
				stopping = TRUE;
				return;
			}
			if (getchordctr > 120)	{
				// -- use the chord being played as tonic
				static short int lastroot;
				static BOOL isminor;
				if (getchordctr == 121)	{
					lastroot = chord.root+31;
					isminor = chord.minor;
				}
				short int bar = (getchordctr-121) / 4;
				short int bt = (getchordctr-121) % 4;
				if (!Tagging)
					bar += 4;
				relative = tagline[bar][bt][0];
				if (isminor && relative == 5)
					relative = 4;
				lastnote = lastroot + relative;
				pMidiOut->NoteOn(1, lastnote, bassvelocity*2);
				return;
			}
		}
	}
	else	{
		if (chordctr < 128)
			chordmemory[chordctr++] = chord;
		lastchord = chord;
	}
	if (lastchord.root && 
			(m_bHalfTime.GetCheck() == 0 || 
				(beat & 1) == 0 ||
					(m_bAutopilot.GetCheck() == 1 && 
						(barcount > 15 && barcount < 24))))	{
		if (barcount < 30 || 
			(barcount == 30 && beat == 0) ||
				onAutoPilot ||
					m_bAutopilot.GetCheck() == 0 ||
						p34Time->GetCheck() == 1)	{
			PlayBassNote(beat, 0);
		}
	}
	if (beat == ((p34Time->GetCheck() == 1) ? 2 : 3))	{
		if (++measure == measures)
			measure = 0;
		if (m_bAutopilot.GetCheck() == 1 && barcount < 32)	{
			if (++barcount == 32)	{
				m_bHalfTime.SetCheck(0);
				onAutoPilot = TRUE;
				m_bLastChorus.EnableWindow(TRUE);
				m_bLastChorus.SetFocus();
				for (short int i = 0; i < 128; i++)
					if (chordmemory[i].root != 0)
						break;
				while (i)	{
					chordmemory[i-1] = chordmemory[i];
					--i;
				}
			}
		}
	}
}
void CMidifitzDlg::PickBass()
{
	if (countoff > 0)	{
		// --- lead-in is in progress
		if ((p34Time->GetCheck() == 1 || 
					countoff < 5 || (countoff & 1) == 0))
			pMidiOut->NoteOn(9, 56, 127);
		--countoff;
	}
	else	{
		BassLine();
		if (beat == 0)	{
			char msr[5];
			sprintf(msr, "%4d", ++measurecnt);
			m_ctlMeasure.SetWindowText(msr);
		}
	}
	beat++;
}
inline void CMidifitzDlg::ComputeExternalTempo()
{
	// --- external sync, compute tempo to display
	MMTIME mmtime;
	timeGetSystemTime(&mmtime, sizeof mmtime);
	DWORD now = mmtime.u.ms;
	const int sample = 4;
	static UINT avg[sample];
	static short avgct = 0;
	if (now != prevtime && prevtime != 0)	{
		UINT delta = now-prevtime;
		if (delta)	{
			if (avgct && abs(delta - avg[0]) > 3)
				avgct = 0;
			// --- maintain average of last (sample) 1/4 notes
			for (short int i = avgct; i > 0; --i)
				avg[i] = avg[i-1];
			avg[0] = delta;
			if (avgct < sample-1)
				avgct++;
			delta = 0;
			for (i = 0; i < avgct; i++)
				delta += avg[i];
			avg[0] = delta / avgct;
			UINT tempo = 60000 / avg[0];
			if (tempo != m_nTempo)	{
				m_nTempo = tempo;
				UpdateData(FALSE);
			}
		}
	}
	if (prevtime == 0)
		avgct = 0;
	prevtime = now;
}
inline void CMidifitzDlg::LastNoteOff()
{
	if (lastnote)	{
		pMidiOut->NoteOn(1, lastnote, 0);
		lastnote = 0;
	}
}

inline void CMidifitzDlg::TimingMsg()
{
	if (playing)	{
		if (stopping)	{
			StopMsg();
			return;
		}
		if (!isExternal)
			pMidiOut->TimingMessage();
		if (++clock == 24)
			clock = 0;
		switch (clock)	{
			case 0:
			{
				if (isExternal)	
					ComputeExternalTempo();
				LastNoteOff();
				PickBass();
				static char *bt[] = { "1 ", "2 ", "3 ", "4 " };
				CString sBeat(bt[0]);
				for (short int i = 1; i < beat; i++)
					sBeat += bt[i];
				m_ctlBeat.SetWindowText(sBeat);
				if (beat == ((p44Time->GetCheck() == 1) ? 4 : 3))
					beat = 0;
				break;
			}
			case 8:
			case 16:
				if (m_bHalfTime.GetCheck() == 0)	{
					if (lines[chrd][measure][beat-1][clock/8])	{
						LastNoteOff();
						PlayBassNote(beat-1, clock/8);
					}
				}
				break;
			case 12:
				if (beat == 0)
					m_ctlBeat.SetWindowText("");
				break;
			case 18:
				LastNoteOff();
				break;
			default:
				break;
		}
	}
}
inline void CMidifitzDlg::StopMsg()
{
	if (playing)	{
		if (lastnote)
			pMidiOut->NoteOn(1, lastnote, 0);
		if (!isExternal)
			pMidiOut->StopMessage();
		lastnote = 0;
		clock = 0;
		playing = FALSE;
		midiChord crd = {{0,0,0,0},0,0,0,0,0,0};
		chord = crd;

		m_ctlChord.SetWindowText("");
		m_ctlBeat.SetWindowText("");
		m_ctlMeasure.SetWindowText("");

		pInternalButton->EnableWindow(TRUE);
		pExternalButton->EnableWindow(TRUE);
		p34Time->EnableWindow(TRUE);
		p44Time->EnableWindow(TRUE);
		m_bAutopilot.EnableWindow(TRUE);
		m_bLastChorus.EnableWindow(FALSE);
		m_bTag.EnableWindow(FALSE);
		if (m_bAutopilot.GetCheck() == 1)
			m_bHalfTime.SetCheck(1);
	}
}
LONG CMidifitzDlg::OnMIDIMessage(WPARAM, LPARAM msg)
{
	// --- extract MIDI message components
	short int velocity = ((msg >> 16) & 0xff);
	short unsigned note = ((msg >> 8) & 0xff);
	short unsigned status = msg & 0xff;
	switch (status)	{
		case 0xb0:		// MIDI status = controller change
			ControllerChange(note, velocity);
			break;
		case 0x90:		// MIDI status = note on
			NoteOn(note, velocity);
			break;
		case 0xfa:		// MIDI status = start timing clock
			if (isExternal)
				StartMsg();
			break;
		case 0xf8:		// MIDI status = timing clock
			if (isExternal)
				TimingMsg();
			break;
		case 0xfc:		// MIDI status = stop timing clock
			if (isExternal)
				StopMsg();
			break;
		default:
			break;
	}
	return 0;
}
void CMidifitzDlg::OnSelchangePiano() 
{
	// --- find which piano selection is current		
	short int voice = pPianoList->GetCurSel();
	if (voice > 7)
		voice += 8;
	if (voice != pianovoice)	{
		// --- piano voice has changed
		if (voice)
			pMidiOut->SetPatch(0, voice-1);
		pianovoice = voice;
		pPianoVolume->EnableScrollBar(voice ? ESB_ENABLE_BOTH : ESB_DISABLE_BOTH);
	}
}

void CMidifitzDlg::OnSelchangeBass() 
{
	// --- find which bass selection is current		
	short int voice = pBassList->GetCurSel() + 32;
	if (voice != bassvoice)	{
		// --- bass voice has changed
		if (voice)
			pMidiOut->SetPatch(1, voice);
		bassvoice = voice;
	}
}

void CMidifitzDlg::OnSelchangeOutdevice() 
{
	outputdevice = m_cOutDevice.GetCurSel();
	pMidiOut->ChangeDevice(outputdevice);
}

void CMidifitzDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
	int *pvelocity;
	int cid = pScrollBar->GetDlgCtrlID();
	if (cid == IDC_BASSVOLUME)
		pvelocity = &bassvelocity;
	else
		pvelocity = &pianovelocity;
	switch (nSBCode)	{
		case SB_LINEUP:
			--(*pvelocity);
			break ;
		case SB_LINEDOWN:
			(*pvelocity)++;
			break ;
		case SB_PAGEUP:
			*pvelocity -= 8;
			break ;
		case SB_PAGEDOWN:
			*pvelocity += 8;
			break ;
		case SB_THUMBTRACK:
		case SB_THUMBPOSITION:
			*pvelocity = nPos;
			break ;
		default:
			break;
	}
	*pvelocity = max(0, min(*pvelocity, 63));
	pScrollBar->SetScrollPos(*pvelocity);
	return;
}

void CMidifitzDlg::AdjustTempo()
{
	if (!isExternal && playing)	{
		ASSERT(timer != 0);
		timeKillEvent(timer);
		UINT ms = tmpo2ms(m_nTempo);
		timer = timeSetEvent(ms, ms, TimerCallback, 0, TIME_PERIODIC);
	}
}
void CMidifitzDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
	if (!isExternal)	{
		int cid = pScrollBar->GetDlgCtrlID();
		if (cid == IDC_TEMPOBUTTONS)	{
			switch (nSBCode)	{
				case SB_LINEDOWN:
					if (m_nTempo > 32)
						--m_nTempo;
					break ;
				case SB_LINEUP:
					if (m_nTempo < 280)
						m_nTempo++;
					break ;
				default:
					return;
			}
			UpdateData(FALSE);
			AdjustTempo();
		}
	}
}

void CMidifitzDlg::OnKillfocusTempo() 
{
	UpdateData(TRUE);
	AdjustTempo();
}

void CMidifitzDlg::OnInternal() 
{
	if (isExternal)	{
		pTempo->EnableWindow(TRUE);
		m_bStartStop.EnableWindow(TRUE);
		m_bStartStop.SetFocus();
		isExternal = FALSE;
	}
}

void CMidifitzDlg::OnExternal() 
{
	if (!isExternal)	{
		pTempo->EnableWindow(FALSE);
		pTempo->SetWindowText("");
		m_bStartStop.EnableWindow(FALSE);
		isExternal = TRUE;
	}
}

static CMidifitzDlg* pCMidifitzDlg;

void CALLBACK TimerCallback(UINT, UINT, DWORD, DWORD, DWORD)
{
	pCMidifitzDlg->TimingMsg();
}

void CMidifitzDlg::OnStartstop() 
{
	static UINT ms = 0;

	if (!playing)	{
		ms = tmpo2ms(m_nTempo);
		StartMsg();
		pCMidifitzDlg = this;
		timer = timeSetEvent(ms, ms, TimerCallback, 0, TIME_PERIODIC);
	}
	else	{
		ASSERT(timer != 0);
		timeKillEvent(timer);
		timer = 0;
		ASSERT(ms != 0);
		timeEndPeriod(ms);
		ms = 0;
		StopMsg();
	}
}

void CMidifitzDlg::OnAutopilot() 
{
	autopilot = (m_bAutopilot.GetCheck() == 1);
	if (autopilot)
		m_bHalfTime.SetCheck(1);	
}

void CMidifitzDlg::OnLastchorus() 
{
	m_bLastChorus.EnableWindow(FALSE);
	m_bTag.EnableWindow(TRUE);
	m_bTag.SetFocus();
	inLastChorus = TRUE;	
}

void CMidifitzDlg::OnTag() 
{
	Tagging = TRUE;	
}
// ---- intercept Enter and Esc keys
void CMidifitzDlg::OnOK()
{
}
void CMidifitzDlg::OnCancel()
{
	if (MessageBox("Terminate MIDI Fitz?", ApplTitle, MB_ICONQUESTION | MB_YESNO) == IDYES)
		CDialog::OnCancel();
}

void CMidifitzDlg::OnLeadin() 
{
	leadin = (m_bLeadin.GetCheck() == 1);
}
