unit CntrlReg;

interface

uses
  Classes, IniFiles, Dialogs,
  AboutPrp, Ctrl3D, ColorBtn, GraphBtn, LBoxChk, LabelFrm, ListHdr, TabBox;

const
  DEF_TABNAME     = 'New Controls';
  INI_SECTION     = 'RWH.DelphiTools';
  INI_TABNAME_ID  = 'ControlsTab';

procedure Register;

implementation

procedure Register;
var
  TabName : String;

begin
  TabName := '';

  with TIniFile.Create('DELPHI.INI') do begin
    try
      TabName := ReadString(INI_SECTION, INI_TABNAME_ID, '');

      if (TabName = '') then
        TabName := InputBox('Install Controls To', 'Component tab name', DEF_TABNAME);

      if (TabName = '') then
        TabName := DEF_TABNAME;

      WriteString(INI_SECTION, INI_TABNAME_ID, TabName);

    finally
      Free;
    end;
  end;

  AboutPrp.Register;
  RegisterComponents(TabName, [TLabel3D, TFramedLabel,
                               TTabListHeader, TTabListBox, TTabComboBox, TCheckListBox,
                               TGraphicButton, TColoredButton, TButton3D]);
end;

end.
