; <:t17,25,41,45:>
; ͻ
;                                                                      
;    Z180.I                                                            
;                                                                      
;    Z180 internal I/O addresses.                                      
;                                                                      
;    Copyright 1994, Frank A. Vorstenbosch                             
;                                                                      
; ͼ
;
; File created 6-dec-94


; Ŀ
;                                                                      
;    Asynchronous serial I/O.                                          
;                                                                      
; 

;  ASCI channel 0 

ASCI_CNTLA0     equ     #00             ; control register A
ASCI_CNTLB0     equ     #02             ; control register B
ASCI_STAT0      equ     #04             ; status
ASCI_TDR0       equ     #06             ; Tx data
ASCI_RDR0       equ     #08             ; Rx data

;  ASCI channel 1 

ASCI_CNTLA1     equ     #01             ; control register A
ASCI_CNTLB1     equ     #03             ; control register B
ASCI_STAT1      equ     #05             ; status
ASCI_TDR1       equ     #07             ; Tx data
ASCI_RDR1       equ     #09             ; Rx data


; Ŀ
;                                                                      
;    Clocked serial I/O.                                               
;                                                                      
; 

CSIO_CNTL       equ     #0a             ; control
CSIO_TRDR       equ     #0b             ; Tx/Rx data


; Ŀ
;                                                                      
;    Programmable reload timer.                                        
;                                                                      
; 

PRT_CNTL        equ     #10             ; control
PRT_FRC         equ     #18             ; free running counter

;  Timer 0 

PRT_DR0L        equ     #0c             ; timer value low
PRT_DR0H        equ     #0d             ; timer value high
PRT_RLDR0L      equ     #0e             ; timer reload low
PRT_RLDR0H      equ     #0f             ; timer reload high

;  Timer 1 

PRT_DR1L        equ     #14             ; timer value low
PRT_DR1H        equ     #15             ; timer value high
PRT_RLDR1L      equ     #16             ; timer reload low
PRT_RLDR1H      equ     #17             ; timer reload high


; Ŀ
;                                                                      
;    DMA.                                                              
;                                                                      
; 

DMA_STAT        equ     #30             ; status
DMA_MODE        equ     #31             ; mode
DMA_CNTL        equ     #32             ; DMA and wait-state control

;  Channel 0 

DMA_SAR0L       equ     #20             ; source address low
DMA_SAR0M       equ     #21             ; source address middle
DMA_SAR0H       equ     #22             ; source address high
DMA_DAR0L       equ     #23             ; destination address low
DMA_DAR0M       equ     #24             ; destination address middle
DMA_DAR0H       equ     #25             ; destination address high
DMA_BC0L        equ     #26             ; byte count low
DMA_BC0H        equ     #27             ; byte count high

;  Channel 1 

DMA_MAR1L       equ     #28             ; memory address low
DMA_MAR1M       equ     #29             ; memory address middle
DMA_MAR1H       equ     #2a             ; memory address high
DMA_IOAR1L      equ     #2b             ; I/O address low
DMA_IOAR1H      equ     #2c             ; I/O address high
DMA_BC1L        equ     #2e             ; byte count low
DMA_BC1H        equ     #2f             ; byte count high


; Ŀ
;                                                                      
;    System control.                                                   
;                                                                      
; 

SYS_RCR         equ     #36             ; refresh control
SYS_OMCR        equ     #3e             ; operation mode control
SYS_ICR         equ     #3f             ; I/O control

;  Interrupt controller 

INT_IL          equ     #33             ; int vector for internal int sources
INT_ITCR        equ     #34             ; int/trap control

;  MMU/bank switch logic 

MMU_CBR         equ     #38             ; common base
MMU_BBR         equ     #39             ; bank base
MMU_CBAR        equ     #3a             ; common/bank area
