 /*
  *============================================================================
  * crypt.c
  *============================================================================
  */
#include "eee.h"

/* making K random numbers */
/* making 16 K 48bits-random numbers by 64bits-key (effective 56bits) */
						/* from 204a:0359 */
int  setkey(char *key)
{
  int i;
  int j;
  int h;
  int k;

    /* PC_1-transposing the key and decomposing 56bits to 1st/2nd half */
    for (i = 0; i < 28; ++i) {
      K0[i] = key[((int)(PC1[i])) - 1];
      K0[i + 28] = key[((int)(PC1[i + 28])) - 1];
    }
    /* making 16 K */
    for (i = 0; i < 16; ++i) {
      /* left-shifting 1st/2nd half respectively by LS[i]bits */
      for (h = 0; ((int)(LS[i])) > h; ++h) {
        k = (int)(K0[0]);
        for (j = 0; j < 27; ++j) {
          K0[j] = K0[j + 1];
        }
        K0[27] = (char)(k);
        k = (int)(K0[28]);
        for (j = 0; j < 27; ++j) {
          K0[j + 28] = K0[j + 29];
        }
        K0[55] = (char)(k);
      }
      /* PC_2-compress/transposing 56bits to 48bits */
      for (j = 0; j < 24; ++j) {
        K[i][j] = K0[((int)(PC2[j])) - 1];
        K[i][j + 24] = K0[((int)(PC2[j + 24])) - 1];
      }
    }
    /* copying E-table and initializing E-transposing area */
    for (i = 0; i < 48; ++i) {
      E[i] = Etable[i];
    }
    return;
}

/* DES-coding */
/* DES-coding 64-bits code by using random numbers K */
						/* from 204a:0411 */
int  encrypt(char *code)
{
  int j;
  int r;
  int i;
  int k;
  int index;

    /* IP-permuting and decomposing to 32bits-1st/2nd half */
    for (j = 0; j < 64; ++j) {
      L0[j] = code[((int)(IP[j])) - 1];
    }
    /* randomizing (2-steps 64bits-randomizing) up to 8 rounds */
    for (i = 0; i < 16; ++i) {
      /* saving the 2nd-32bits half */
      for (j = 0; j < 32; ++j) {
        R0[j] = L0[j + 32];
      }
      for (j = 0; j < 48; ++j) {
        /* E-table extend/transposing the 2nd-32bits half to 48bits */
        r = (int)(L0[((int)(E[j])) + 31]);
        /* binary composing (XOR) with K random numbers */
        k = (int)(K[i][j]);
        R[j] = ((char)(r)) ^ ((char)(k));
      }
      /* decomposing 48bits to 8 classes with 6bits and, to each class, */
      for (j = 0; j < 8; ++j) {
        index = (((((((int)(R[j * 6])) << 5) + ((int)(R[(j * 6) + 4]))) + (((int)(R[(j 
* 6) + 5])) << 4)) + (((int)(R[(j * 6) + 3])) << 1)) + (((int)(R[(j * 6) + 2])) 
<< 2)) + (((int)(R[(j * 6) + 1])) << 3);
        /* transforming 6bits to 4bits by S[j]-table */
        r = (int)(S[j][index]);
        R0[(j << 2) + 32] = ((char)(r >> 3)) & 1;
        R0[(j << 2) + 33] = ((char)(r >> 2)) & 1;
        R0[(j << 2) + 34] = ((char)(r >> 1)) & 1;
        R0[(j << 2) + 35] = ((char)(r)) & 1;
      }
      /* such made 32bits being */
      for (j = 0; j < 32; ++j) {
        /* transposed by P-table */
        r = (int)(R0[((int)(P[j])) + 31]);
        /* and composed to the 1st-32bits half */
        L0[j + 32] = L0[j] ^ ((char)(r));
      }
      /* regarding the 2nd-32bits half saved as the 1st half at next step */
      for (j = 0; j < 32; ++j) {
        L0[j] = R0[j];
      }
      /* to next step */
    }
    /* replacing 1st with 2nd and recovering the original ones */
    for (j = 0; j < 32; ++j) {
      r = (int)(L0[j]);
      L0[j] = L0[j + 32];
      L0[j + 32] = (char)(r);
    }
    /* IP-reverse-transforming and getting the 64bits cryption */
    for (j = 0; j < 64; ++j) {
      code[j] = L0[((int)(PI[j])) - 1];
    }
    return;
}

/* making cryption string */
/* DES-coding 25 times by K-random numbers of password */
						/* from 2042:0064 */
char *crypt(char *password, char *salt)
{
  int i;
  int d;
  int j;
  int e;

    /* initializing cryption bit area */
    for (i = 0; i < 66; ++i) {
      C[i] = 0;
    }
    /* transforming password to 64bits */
    for (i = 0; ((*password) != 0) && (i < 64); ++password) {
      d = (int)(*password);
      /* picking up the lower 7 bits */
      for (j = 0; j < 7; ++i) {
        C[i] = ((char)(d >> (6 - ((char)(j))))) & 1;
        ++j;
      }
      ++i;
    }
    /* making K random numbers */
    setkey(&C[0]);
    /* initializing cryption bit area */
    for (i = 0; i < 66; ++i) {
      C[i] = 0;
    }
    for (i = 0; i < 2; ++i) {
      d = (int)(*salt);
      ++salt;
      /* remaining the original 2 characters of salt */
      T[i] = (char)(d);
      if (d > 90) {
        d -= 6;
      }
      if (d > 57) {
        d -= 7;
      }
      d -= 46;
      /* by the lower 6bits of salt, */
      for (j = 0; j < 6; ++j) {
        /* exchanging forward with backward E-table */
        if (((d >> ((int)((char)(j)))) & 1) != 0) {
          e = (int)(E[(i * 6) + j]);
          E[(i * 6) + j] = E[((i * 6) + j) + 24];
          E[((i * 6) + j) + 24] = (char)(e);
        }
      }
    }
    /* DES-coding 25 times */
    for (i = 0; i < 25; ++i) {
      encrypt(&C[0]);
    }
    /* transforming such made 64bits to 11 characters */
    for (i = 0; i < 11; ++i) {
      d = 0;
      for (j = d; j < 6; ++j) {
        d <<= 1;
        d |= (int)(C[(i * 6) + j]);
      }
      d += 46;
      if (d > 57) {
        d += 7;
      }
      if (d > 90) {
        d += 6;
      }
      T[i + 2] = (char)(d);
    }
    T[13] = 0;
    if (T[1] == 0) {
      T[1] = T[0];
    }
    /* returning 13 characters as result */
    return &T[0];
}

