
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __NCPCOMM_H__

#define __NCPCOMM_H__

#include <time.h>
#include "stdtypes.h"

#define NOT_LOGGED	(0xFFFFFFFFUL)
#define server_name	cmdline.sname
#define SERVER_NAME	server_name.name
#define MAX_OBJ_NAME	(48)

struct ncp_object_name
{
	char name[MAX_OBJ_NAME]		__attribute__ ((packed));
};

struct ncp_date_info
{
	byte	year		__attribute__ ((packed));
	byte	month		__attribute__ ((packed));
	byte	day		__attribute__ ((packed));
	byte	hour		__attribute__ ((packed));
	byte	min		__attribute__ ((packed));
	byte	sec		__attribute__ ((packed));
	byte	week_day	__attribute__ ((packed));
};

struct ncp_message
{
	byte len			__attribute__ ((packed));
	char msg[256]			__attribute__ ((packed));	
};

struct ncp_con_list
{
	byte len			__attribute__ ((packed));
	byte list[1]			__attribute__ ((packed));
};

struct ncp_con_list32
{
	byte len			__attribute__ ((packed));
	dword list[1]			__attribute__ ((packed));
};

struct ncp_log_key
{
	char key[8]		__attribute__ ((packed));
};

struct ncp_string
{
	byte name_len		__attribute__ ((packed));
	char name[1]		__attribute__ ((packed));
};

typedef word ncp_date;
typedef word ncp_time;

typedef
struct
{
	char name[14]		__attribute__ ((packed));
} ncp_filename;

ncp_date time2nw_date(time_t t);
ncp_time time2nw_time(time_t t);
time_t nw2time(ncp_date d,ncp_time t);
void ncp_get_date(struct ncp_date_info* nfo);

#endif /* __NCPCOMM_H__ */
