
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef __LOGGING_H__

#define __LOGGING_H__

#include <stdio.h>

/* read only! */
extern int log_new_entry;
extern int log_level;
extern FILE* log_file;

/* to handle complicated cases */
#define LOG_START(l)	{if (l<=log_level) {\
			if (log_new_entry) {log_print_time(); log_new_entry=0;}
			
#define LOG_END		fflush(log_file);}}
/* for "daily purpose" */
#define LOG_ENTRY	{log_new_entry=1;}
#define LPRINTF(l,m)	LOG_START(l) log_printf m; LOG_END

void log_set_level(int new_log_lvl);
FILE* log_set_file(FILE* new_log_file);
void log_print_time();
void log_printf(char* fmt,...);

#endif /* __LOGGING_H__ */
