
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef __FILESEARCH_H__

#define __FILESEARCH_H__

#include "fsystem.h"
#include <sys/stat.h>

#if 0
#define ER_SUPERVISORY	0001
#define ER_READ		0002
#define ER_WRITE	0004
#define ER_CREATE	0010
#define ER_ERASE	0020
#define ER_FILESCAN	0040
#define ER_MODIFY	0100
#define ER_ACCESS	0200	
#endif 

#define ER_READ		0001
#define ER_WRITE	0002
#define ER_OPEN		0004
#define ER_CREATE	0010
#define ER_DELETE	0020
#define ER_PARENT	0040
#define ER_SEARCH	0100
#define ER_MODIFY	0200	

#define AR_READ		0001
#define AR_WRITE	0002
#define AR_EXCLUSIVE	0020
#define AR_ARCHIVE	0040

typedef
union
{
	struct ncp_file_prop
	{	
		byte		f_attr	__attribute__ ((packed));
		byte		f_mode	__attribute__ ((packed));
		dword		f_size	__attribute__ ((packed));
		ncp_date	d_creat __attribute__ ((packed));
		ncp_date	d_acc	__attribute__ ((packed));
		ncp_date	d_upd	__attribute__ ((packed));
		ncp_time	t_upd	__attribute__ ((packed));	
	} file			__attribute__ ((packed));
	struct ncp_dir_prop
	{
		byte		d_attr	__attribute__ ((packed));
		byte		d_acc	__attribute__ ((packed));
		ncp_date	d_creat	__attribute__ ((packed));
		ncp_time	t_creat	__attribute__ ((packed));
		dword		uid	__attribute__ ((packed));
		word		fill	__attribute__ ((packed));
		word		stamp	__attribute__ ((packed));
	} dir			__attribute__ ((packed));
} ncp_filedir_prop;

void ncp_set_filedir_prop(ncp_filedir_prop* prop,struct stat* fs);
int nw_file_search_path(ncp_filename* name,word* new_context,ncp_filedir_prop* prop,
		   char* path,char* template,byte attr,word context);
int nw_file_search(ncp_filename* name,word* new_context,ncp_filedir_prop* prop,
		   dir_handle* dh,char* search_path,char* template,byte attr,word context);
int nw_file_search1(ncp_filename* name,word* new_context,ncp_filedir_prop* prop,
		   dir_handle* dh,char* path,byte attr,word context);
byte unix2nw_rights(int rights,int ouid,int ogid);

#endif /* __FILESEARCH_H__ */