
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __FILEOPS_H__

#define __FILEOPS_H__

#include "connect.h"
#include "filesearch.h"

struct ncp_file_id
{
	char id[6];
};

void ncp_set_file_id(struct ncp_file_id* id,int idx);
int ncp_get_file_idx(struct ncp_file_id* id);

struct ncp_file_search_init_rq
{
	byte	dir_handle	__attribute__ ((packed));
	byte	path_len	__attribute__ ((packed));
	char	path[1]		__attribute__ ((packed));
};

struct ncp_file_search_init_rpl
{
	byte	vol_id		__attribute__ ((packed));
	word	dir_id		__attribute__ ((packed));
	word	seq_num		__attribute__ ((packed));
	byte	access		__attribute__ ((packed));
};

struct ncp_file_search_cont_rq
{
	byte	vol_id		__attribute__ ((packed)); 
	word	dir_id		__attribute__ ((packed));
	word	context		__attribute__ ((packed));
	byte	attr		__attribute__ ((packed));
	byte	path_len	__attribute__ ((packed));
	char	path[1]		__attribute__ ((packed));
};

struct ncp_file_search_cont_rpl
{
	word			context	__attribute__ ((packed));
	word			zero	__attribute__ ((packed));
	ncp_filename		f_name	__attribute__ ((packed));
	ncp_filedir_prop	prop	__attribute__ ((packed));
};

struct ncp_search_file_rq
{
	word			context		__attribute__ ((packed));
	byte			dir_id		__attribute__ ((packed));
	byte			attr		__attribute__ ((packed));
	struct ncp_string	path		__attribute__ ((packed));
};

struct ncp_search_file_rpl /* same as file seach cont ? */
{
	word			context	__attribute__ ((packed));
	word			zero	__attribute__ ((packed));
	ncp_filename		f_name	__attribute__ ((packed));
	ncp_filedir_prop	prop	__attribute__ ((packed));
};

struct ncp_rename_file
{
	byte			old_handle	__attribute__ ((packed));
	byte			attr		__attribute__ ((packed));
	struct ncp_string	old_path	__attribute__ ((packed));
};

struct ncp_rename_file_new
{
	byte			new_handle	__attribute__ ((packed));
	struct ncp_string	new_path	__attribute__ ((packed));
};

struct ncp_close_file
{
	byte			fill	__attribute__ ((packed));
	struct ncp_file_id	id	__attribute__ ((packed));
};

struct ncp_open_file_rq 
{
	byte			dir_handle	__attribute__ ((packed));
	byte			attr		__attribute__ ((packed));
	byte			access		__attribute__ ((packed));
	struct ncp_string	path		__attribute__ ((packed));
};

struct ncp_open_file_rpl
{
	struct ncp_file_id	id	__attribute__ ((packed));
	word			zero	__attribute__ ((packed));
	ncp_filename		f_name	__attribute__ ((packed));
	ncp_filedir_prop	prop	__attribute__ ((packed));
};

struct ncp_set_file_attr
{
	byte			attr		__attribute__ ((packed));
	byte			dir_handle	__attribute__ ((packed));
	byte			search_attr	__attribute__ ((packed));
	struct ncp_string	path		__attribute__ ((packed));
};

struct ncp_set_file_time
{
	byte			fill		__attribute__ ((packed));
	struct ncp_file_id	id		__attribute__ ((packed));
	ncp_time		time		__attribute__ ((packed));
	ncp_date		date		__attribute__ ((packed));
	word			zero		__attribute__ ((packed));
};

struct ncp_get_filesize
{
	byte			fill		__attribute__ ((packed));
	struct ncp_file_id	id		__attribute__ ((packed));
};

struct ncp_creat_file
{
	byte			dir_handle	__attribute__ ((packed));
	byte			attr		__attribute__ ((packed));
	struct ncp_string	path		__attribute__ ((packed));
};

struct ncp_read_file_rq
{
	byte			fill	__attribute__ ((packed));
	struct ncp_file_id	id	__attribute__ ((packed));
	dword			offset	__attribute__ ((packed));
	word			to_read	__attribute__ ((packed));
};

struct ncp_read_file_rpl
{
	word	read	__attribute__ ((packed));
	char	data[1]	__attribute__ ((packed));
};

struct ncp_write_file
{
	byte			fill		__attribute__ ((packed));
	struct ncp_file_id	id		__attribute__ ((packed));
	dword			offset		__attribute__ ((packed));
	word			to_write	__attribute__ ((packed));
	char			data[1]		__attribute__ ((packed));
};

#endif /* __FILEOPS_H__ */
