
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __CONNECT_H__

#define __CONNECT_H__

#include "config.h"
#include "bindery.h"
#include "ipxncp.h"
#include "ncpcomm.h"

typedef struct
{
	int alloc;
	/* authorization & authentication */
	struct bindery_object* logged_obj;
	struct ncp_date_info login_time;
	struct sockaddr_ipx peer_addr;
	struct ncp_log_key last_key;
	int timer; /* conn timeout, set to zero: any request, valid conn */
	int wdog_timer; /* watch dog: any request, valid conn, poll station */
	/* messages */
	int msg_hold;
	int msg_timer;
	struct ncp_message msg; 
	/* NCP protocol */
	byte out_seq;
	struct ncp_reply* out_buf;
	word out_size;
	/* file search */
	int sh[MAX_SEARCH_CONN];
	  /* stat */
	int stat_lsalloc;
	int stat_lshit;
	int stat_gsalloc;
	int stat_gshit;
/*	char search_path[MAX_PATH];*/
	/* local dir handles table*/
	int dh[MAX_DIR_CONN];
	/* local file table */
	int fh[MAX_FILE_CONN];
} connection;

connection* get_conn(int id);
int get_conn_id(connection* c);
int alloc_conn();
byte* get_conn_buf(connection* c);
void notify_unreachable(IPXNet net);
void free_conn(connection* c);
void init_connections();
void done_connections();

void fprint_conn_stat(FILE* file,connection* c);

#endif /* __CONNECT_H__ */
