
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __CONFIG_H__

#define __CONFIG_H__

#include <limits.h>

#define MAX_CONNECT	(100)
#define BUF_SIZE	(2048)
#define MAX_DIR		(256)
#define MAX_DIR_CONN	(32)
#define MAX_VOL_NAME	(16)
#define MAX_VOLUME	(5)
#define MAX_FILE	(256)
#define MAX_FILE_CONN	(256)
#define MAX_SEARCH	(1024)
#define MAX_SEARCH_CONN	(1024)
#define MAX_DESCRIPTION	(1024)

/* timings in seconds */
#define TIMER_RATE 	10  
#define SAP_NOTIFY	60  
#define SAP_QUERY  	60
#define SAP_TIMEOUT	(3*SAP_QUERY)
#define CONN_QUERY	15
#define CONN_TIMEOUT	(4*CONN_QUERY)
#define MSG_NOTIFY	20
#define DOWN_DELAY	10

#define MAX_PATH PATH_MAX

#define ROOT_UID	0
#define ROOT_GID	0
#define NOBODY_UID	10000
#define NOBODY_GID	10000

#define LOG_FILENAME	"/var/adm/lware.log"
#define PASSWD_FILENAME	"/etc/lwpasswd"
#define	VOL_FILENAME	"/etc/lwvtab"

/* log levels */
#define LL_FATAL	0
/* can't continue */ 
#define LL_ERROR	1
/* serious error - send packet, disk I/O */
#define LL_INFO		2
/* important activities - login, logout */
#define LL_FULL		3
/* any activities */
#define LL_DEBUG	4
/* as many information as possible */

#endif /* __CONFIG_H__ */
