
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __BCAST_H__

#define __BCAST_H__

#include <stdio.h>
#include "connect.h"

#define IPX_BCAST_PORT(c)	(ntohs(c->peer_addr.sipx_port)+2)
#define IPX_BCAST_MSG_NOTIFY	('!')

typedef
struct tagBcastPacket
{
	byte	cid		__attribute__((packed));
	byte	sign_char	__attribute__((packed));
} BcastPacket;

void ipx_bcast_dump(BcastPacket* buf,int size);
void ipx_bcast_fdump(FILE* file,BcastPacket* buf,int size);
void bcast_send(connection* c,char sign_char);

#endif /* __BCAST_H__ */
