
/*
    LinuxWare daemon - Netware like server for Linux

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <netinet/in.h>
#include "ncp.h"
#include "logging.h"
#include "bcast.h"

void ipx_bcast_dump(BcastPacket* buf,int size)
{
	ipx_bcast_fdump(stdout,buf,size);
}

void ipx_bcast_fdump(FILE* file,BcastPacket* buf,int size)
{
	if (size!=sizeof(BcastPacket))
	{
		fprintf(file,"Invalid BCAST size %i\n",size);
		return;
	}
	fprintf(file,"connection: %i\nsignature character: %c\n",buf->cid,buf->sign_char);
}

void bcast_send(connection* c,char sign_char)
{
	BcastPacket buf;
	struct sockaddr_ipx station_addr;

	station_addr=c->peer_addr;
	station_addr.sipx_port=htons(IPX_BCAST_PORT(c));
	station_addr.sipx_type=IPX_USER_PTYPE;
	buf.cid=get_conn_id(c);
	buf.sign_char=sign_char;

	LOG_START(LL_DEBUG)
	log_printf("Sending BCAST packet to: ");
	ipx_fprint_saddr(log_file,&station_addr);
	log_printf("\n");
	ipx_bcast_fdump(log_file,&buf,sizeof(buf));
	LOG_END

	ncp_raw_send(&station_addr,(char*)&buf,sizeof(buf));
}
