
/*

    IPX support library

    Copyright (C) 1994, 1995  Ales Dryak <e-mail: A.Dryak@sh.cvut.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef __IPXSAP_H__

#define __IPXSAP_H__

#include <stdio.h>
#include "ipxutil.h"

#define IPX_SAP_PORT		(0x452U)
#define IPX_SAP_PTYPE		(4U)
#define IPX_SAP_OP_REQUEST	(1U)
#define IPX_SAP_GENERAL_RQ	(0xFFFFU)
#define IPX_SAP_OP_RESPONSE	(2U)
#define IPX_SAP_OP_GNS_REQUEST	(3U)
#define IPX_SAP_OP_GNS_RESPONSE	(4U)
#define IPX_SAP_MAX_ENTRIES	(7U)
#define IPX_SAP_SERVER_DOWN	(16U)
#define IPX_SAP_SERVER_NAME_LEN	(48U)
#define IPX_SAP_REQUEST_LEN	(4U)

typedef unsigned short int hop_t;
typedef unsigned short int ser_type_t;
typedef char ser_name_t[IPX_SAP_SERVER_NAME_LEN];

typedef struct
{
	ser_type_t ser_type __attribute__ ((packed));
	ser_name_t ser_name __attribute__ ((packed));
	IPXNet network __attribute__ ((packed));
	IPXNode node __attribute__ ((packed));
	IPXPort port __attribute__ ((packed));
	hop_t hops __attribute__ ((packed));
} SapEntry;

typedef struct
{
	unsigned short int operation __attribute__ ((packed));
	SapEntry sap_entries[1] __attribute__ ((packed));
} SapPacket;

SapPacket* ipx_sap_alloc(int n);
int ipx_sap_size(int n,unsigned short int operation);
void ipx_sap_dump(SapPacket* pkt,int len);
void ipx_sap_fdump(FILE* file,SapPacket* pkt,int len);
void ipx_sap_assign_ser_name(ser_name_t dest,ser_name_t src); 
void ipx_sap_fprint_name(FILE* file,ser_name_t sname);
int ipx_sap_name_equal(ser_name_t n1,ser_name_t n2);
int ipx_sap_type_equal(ser_type_t t1,ser_type_t t2);

typedef struct tagSapOutput
{
	struct sockaddr_ipx dest_addr;
	int entries;
	SapPacket* buffer;
} SapOutput;

int ipx_sap_output_sap_output(SapOutput* out,IPXNet iface);
void ipx_sap_output_flush(SapOutput* out);
void ipx_sap_output_request(SapOutput* out,ser_type_t ser_type);
void ipx_sap_output_gns_request(SapOutput* out,ser_type_t ser_type);
void ipx_sap_output_response(SapOutput* out,ser_type_t type,ser_name_t name,struct sockaddr_ipx* addr,hop_t hops,int down_allow);
void ipx_sap_output_gns_response(SapOutput* out,ser_type_t type,ser_name_t name,struct sockaddr_ipx* addr,hop_t hops);
void ipx_sap_output_set_destination(SapOutput* out,IPXNode node,IPXPort port);

extern void (*ipx_sap_output_func)(void* buffer,int size,struct sockaddr_ipx* daddr);

#endif
