#!/usr/bin/perl

&SetAutoScreenDestructionMode(1); # go away automatically

$inFile = $ARGV[6];
$outFile = "> " . $ARGV[7];

close(STDIN);
close(STDOUT);
open(STDIN,$inFile);
open(STDOUT,$outFile);

$data_file = "sys:/etc/stepmail.dat";

$query = $ARGV[5];

if($query eq "__CGI_NO_VALUE__")
    {
    # No Argument, so prompt the user for one!
    &html_header("Mail Search Query");
    print "<ISINDEX>";
    &html_trailer;
    }
else
    {
    # The search string was appended to the URL.
    # Massage it back to useable form.
    $query =~ tr/+/ /;
    $query =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

    # Check for illegal metacharacters
    if ($query !~ /^[a-zA-Z0-9_\-+ \t\/@%]+$/)
        {
        &html_header("Illegal Characters");
        print "The search phrase contains illegal \n";
        print "characters.  Please back up and resubmit \n";
        print "the query.<p>";
        &html_trailer;
        }
    else
        {
        &html_header("Address Search Results");
        print "<PRE>\n";
        open(DATAFILE,"$data_file");
        while(<DATAFILE>) 
             {
             if (/$query/i) {print;}
             }
        close(DATAFILE);
        print "</pre>";
        &html_trailer;
     }
}


close(STDIN);
close(STDOUT);


sub html_header {
  $document_title = $_[0];
  print "<html>\n";
  print "<head>\n";
  print "<title>$document_title</title>\n";
  print "</head>";
  print "<body>";
  print "<h2>$document_title</h2>";
}

sub html_trailer {
print "</body>";
print "</html>";
}  


#This routine causes the sceeen to be destroyed
#immediately.
#Use it like this:
#&SetAutoScreenDestructionMode(1); # go away automatically
#&SetAutoScreenDestructionMode(0); # stick around

sub SetAutoScreenDestructionMode {
  local($newmode) = $_[$[];
  local($func) = &Symbol'Import("SetAutoScreenDestructionMode");
  die "$!" if ($func == 0);
  local($args) = pack("i", $newmode);
  local($ret) = &Symbol'Call($func, $args);
  &Symbol'Unimport("SetAutoScreenDestructionMode");
  $ret = unpack("i", $ret);
  # return $ret
}


