//
// SPERM - swimming sperm SPX library
//
// Version 1.0 12/18/92 Copyright (C) 1992 Hutchins Software
// Author: Edward Hutchins
// Revisions:
//

#include "sperm.h"

//
// globals
//

GLOBAL HANDLE       hLibInst;                           // current instance
GLOBAL INT          nSpermCnt;                          // number of colors
GLOBAL BOOL         bEnabled;                           // SPX enable switch
GLOBAL TRI          triBlank;                           // blank screen first
GLOBAL CHAR         szAppName[] = "Screen Peace";       // saver app name
GLOBAL CHAR         szSaverName[] = "Sperm";            // SPX name
GLOBAL CHAR         szProfSpermCnt[] = "Sperm Count";   // profiler key
GLOBAL CHAR         szProfEnabled[] = "Sperm On";       // profiler key
GLOBAL CHAR         szProfBlank[] = "Sperm Blank";      // profiler key

//
// GetProfileTri - get a tri-state variable from the profile
//

TRI NEAR PASCAL GetProfileTri( LPSTR lpszKey )
{
	GLOBAL CHAR         szBuff[64];

	GetProfileString( szAppName, lpszKey, "u", szBuff, sizeof(szBuff) );
	switch (szBuff[0])
	{
	case 'N': case 'n':
		return( TRI_FALSE );
	case 'Y': case 'y':
		return( TRI_TRUE );
	default:
		return( TRI_UNSET );
	}
}

//
// WriteProfileTri - write a tri-state variable to the profile
//

BOOL NEAR PASCAL WriteProfileTri( LPSTR lpszKey, TRI tri )
{
	switch (tri)
	{
	case TRI_FALSE:
		return( WriteProfileString( szAppName, lpszKey, "n" ) );
	case TRI_TRUE:
		return( WriteProfileString( szAppName, lpszKey, "y" ) );
	default:
		return( WriteProfileString( szAppName, lpszKey, "u" ) );
	}
}

//
// WriteProfileInt - write an integer to the profile
//

BOOL NEAR PASCAL WriteProfileInt( LPSTR lpszKey, INT nVal )
{
	GLOBAL CHAR         szBuff[64];

	wsprintf( szBuff, "%u", nVal );
	return( WriteProfileString( szAppName, lpszKey, szBuff ) );
}

//
// LibMain - initialize the local data segment
//

BOOL FAR PASCAL EXPORT LibMain( HINSTANCE hInstance, WORD wDataSeg,
								WORD wHeapSize, LPSTR szCmdLine )
{
	hLibInst = hInstance;
	nSpermCnt = GetProfileInt( szAppName, szProfSpermCnt, SPERM_MAX / 2 );
	bEnabled = GetProfileTri( szProfEnabled );
	triBlank = GetProfileTri( szProfBlank );
	UnlockData( 0 );
	return( TRUE );
}

//
// WEP - Windows Exit Procedure, clean up resources
//

VOID FAR PASCAL EXPORT WEP( BOOL bSystemExit )
{
}

//
// SaverInit - register with Screen Peace
//

LPSTR FAR PASCAL EXPORT SaverInit( LPBOOL lpbEnabled )
{
	*lpbEnabled = bEnabled;
	return( szSaverName );
}

//
// SaverDlgProc - dialog proc for user customization
//

BOOL FAR PASCAL EXPORT SaverDlgProc( HWND hdlg, WORD mess, WORD wP, LONG lP )
{
	switch (mess)
	{
	case WM_INITDIALOG:
		SetDlgItemInt( hdlg, IDD_S_SPERMCNT, nSpermCnt, FALSE );
		SendDlgItemMessage( hdlg, IDD_S_ENABLE, BM_SETCHECK, bEnabled, 0 );
		SendDlgItemMessage( hdlg, IDD_S_BLANK, BM_SETCHECK, triBlank, 0 );
		return( TRUE );

	case WM_COMMAND:
		switch (wP)
		{
		case IDOK:
			nSpermCnt = GetDlgItemInt( hdlg, IDD_S_SPERMCNT, NULL, FALSE );
			bEnabled = (BOOL)SendDlgItemMessage( hdlg, IDD_S_ENABLE, BM_GETCHECK, 0, 0 );
			triBlank = (TRI)SendDlgItemMessage( hdlg, IDD_S_BLANK, BM_GETCHECK, 0, 0 );
			WriteProfileTri( szProfEnabled, bEnabled );
			if (bEnabled)
			{
				WriteProfileInt( szProfSpermCnt, nSpermCnt );
				WriteProfileTri( szProfBlank, triBlank );
			}
			EndDialog( hdlg, TRUE );
			return( TRUE );

		case IDCANCEL:
			EndDialog( hdlg, FALSE );
			return( TRUE );
		}
		break;
	}
	return( FALSE );
}
