/*** TERM_IO.C ***/

#include "windows.h"
#include <stdio.h>
#include <string.h>
#include "pcl4w.h"
#include "term.h"
#include "ascii.h"
#include "sioerror.h"
#include "term_io.h"
#include "paint.h"

#define MIN(a,b) ((a<=b)?(a):(b))

/* public globals */
extern int DebugFlag;

/* private */
#define BUF_SIZE 256
static char DisplayBuffer[BUF_SIZE];
static int  BufferCount = 0;
static int  FatalError = FALSE;
static int  RetryCount = 2;
static int  TheCharWait = 20;

void TermInit(void)
{/* null */
}

void TermDone(void)
{/* null */
}

/* output character to serial port */

int PutChar(int Port, char ch)
{int i, rc;
 if(FatalError) return(-99);
 /* make several attempts */
 for(i=1;i<=RetryCount;i++)
   {/* transmit character */
    rc = SioPutc(Port,ch);
    if(rc>=0) return (rc);
    if(rc<-1)
      {/* error */
       SioError(rc,"SioPutc");
       SioDone(Port);
      }
    /* rc == -1 (timeout) */
    DelayMS(TheCharWait);
  }
 return(rc);
} /* end PutChar */

/* set GetChar() & PutChar retry count */

void SetRetryCount(int Count)
{/* set GetChar & PutChar t/o retry count */
 RetryCount = Count;
} /* end SetCharWait */

/* read character from serial port */

int GetChar(int Port)
{int rc;
 int i;
 if(FatalError) return(-99);
 /* make several attempts */
 for(i=1;i<=RetryCount;i++)
   {rc = SioGetc(Port);
    if(rc>=0) break;
    if(rc<-1)
      {/* error */
       SioError(rc,"SioGetc");
       SioDone(Port);
      }
    /* rc == -1 (timeout) */
    DelayMS(TheCharWait);
   }
 return(rc);
} /* end GetChar */

/* display the error text */

void SayError(int Port, char *ptr)
{char temp[81];
 sprintf(temp,"ERROR! COM%d : %s\n",1+Port,ptr);
 DisplayLine(temp);
 /* cancel remote */
 PutChar(Port,CAN);
 PutChar(Port,CAN);
 PutChar(Port,CAN);
} /* end SayError */

/* display characters in display buffer on TERM client area */

void FlushDisplay(void)
{if(BufferCount>0)
  {WriteTheString(DisplayBuffer,BufferCount);
   BufferCount = 0;
  }
}

/* add character to display buffer */

void DisplayChar(char TheChar)
{
 if(BufferCount==BUF_SIZE) FlushDisplay();
 DisplayBuffer[BufferCount++] = TheChar;
}


/* add (counted) array to display buffer */

void DisplayArray(char *Ptr, int Count)
{int i;
 int Len;
 Len = MIN(BUF_SIZE,Count);
 if(BufferCount+Len >= BUF_SIZE) FlushDisplay();
 for(i=0;i<Len;i++) DisplayBuffer[BufferCount++] = Ptr[i];
 if(Ptr[Len-1]=='\n') DisplayBuffer[BufferCount++] = CR;
} /* end DisplayArray */

/* add string to display buffer */

void DisplayLine(char *Ptr)
{DisplayArray(Ptr,strlen(Ptr));
} /* end DisplayLine */

void DelayMS(int Wait)
{long TimeMark;
 TimeMark = GetTickCount() + (long)Wait;
 while(GetTickCount()<TimeMark);
}
