;  TEST8096.ASM - Test file for 80(1)96 disassembler
;
;  28-Oct-94 by John Hartman
;  27-Jan-94 JLH Final cleanup
;
;  Assembled using the freeware version of the PseudoSam 8096 assembler
;
;  EQUATES FOR ADDRESS MODES
        .equ    AX,H'A0
        .equ    BX,H'B0
        .equ    CX,H'C0

        .equ    NN,H'12         ;IMMEDIATE 8
        .equ    NNNN,H'1234     ;IMMEDIATE 16

        .org     H'D000		;Someplace in RAM...
;
;==========================================================================
;  80196 instructions, commented out below.
;  My assembler can't handler these.  I have hand assembled them to
;  test the disassembler and single-step, but I can't absolutely
;  guarantee operand order, especially for TIJMP.
;  Does NoICE disassemble them correctly when you assemble them?
;;        XCH      AX,BX          ; 04
;;        XCH      AX,NN[BX]      ; 0B
;;        XCH      AX,NNNN[BX]    ; 0B
;;        XCHB     AX,BX          ; 14
;;        XCHB     AX,NN[BX]      ; 1B
;;        BMOV     AX,BX          ; C1
;;        CMPL     AX,BX          ; C5
;;        BMOVI    AX,BX          ; CD
;;        DJNZW    AX,MMMM        ; E1
;;        TIJMP    AX,[BX],#NN    ; E2
;;  My Intel 8XC196KC/KD databook shows the above assembler syntax, 
;;  where AX points to the jump table, BX points to the index byte, and
;;  NN is the mask.  They also claim that the argument byte order is
;;  AX, NN, BX.  By experiment, I found the byte order to be
;;  BX, NN, AX; which NoICE will disassemble to match the above syntax.
;;
;;        DPTS                    ; EC
;;        EPTS                    ; ED
;;        PUSHA                   ; F4
;;        POPA                    ; F5
;;        IDLPD    #1             ; F6
;
;==========================================================================
;  Addressing modes and variants
        POP      [AX]           ; CE
        POP      [AX]+          ; CE
        POP      NN[AX]         ; CF
        POP      -NN[AX]        ; CF
        POP      NNNN[AX]       ; CF
        POP      -NNNN[AX]      ; CF

        SHR      AX,5           ; 08
        SHR      AX,BX          ; 08

        AND      AX,[BX]        ; 62
        AND      AX,[BX]+       ; 62
        AND      AX,NN[BX]      ; 63
        AND      AX,NNNN[BX]    ; 63

        AND      AX,BX,[CX]     ; 42
        AND      AX,BX,[CX]+    ; 42
        AND      AX,BX,NN[CX]   ; 43
        AND      AX,BX,NNNN[CX] ; 43
;
;==========================================================================
;  Op-codes in numerical order
        SKIP     AX             ; 00
        CLR      AX             ; 01
        NOT      AX             ; 02
        NEG      AX             ; 03
;       XCH      AX,BX          ; 04 (8XC196KC)
        DEC      AX             ; 05
        EXT      AX             ; 06
        INC      AX             ; 07
        SHR      AX,5           ; 08
        SHL      AX,5           ; 09
        SHRA     AX,5           ; 0A
;;      XCH      AX,NNNN[BX]    ; 0B (8XC196KC)
        SHRL     AX,5           ; 0C
        SHLL     AX,5           ; 0D
        SHRAL    AX,5           ; 0E
        NORML    AX,BX          ; 0F

        .db      H'10           ; 10
        CLRB     AX             ; 11
        NOTB     AX             ; 12
        NEGB     AX             ; 13
;       XCHB     AX,BX          ; 14 (80XC196KC)
        DECB     AX             ; 15
        EXTB     AX             ; 16
        INCB     AX             ; 17
        SHRB     AX,5           ; 18
        SHLB     AX,5           ; 19
        SHRAB    AX,5           ; 1A
;       XCHB     AX,NN[BX]      ; 1b (80XC196KC)
        .db      H'1C           ; 1C
        .db      H'1D           ; 1D
        .db      H'1E           ; 1E
        .db      H'1F           ; 1F

        SJMP     SSSS + H'000   ; 20
        SJMP     SSSS + H'100   ; 21
        SJMP     SSSS + H'200   ; 22
        SJMP     SSSS + H'300   ; 23
        SJMP     SSSS - H'400   ; 24
        SJMP     SSSS - H'300   ; 25
        SJMP     SSSS - H'200   ; 26
        SJMP     SSSS - H'100   ; 27
        SCALL    SSSS + H'000   ; 28
        SCALL    SSSS + H'100   ; 29
        SCALL    SSSS + H'200   ; 2A
        SCALL    SSSS + H'300   ; 2B
        SCALL    SSSS - H'400   ; 2C
        SCALL    SSSS - H'300   ; 2D
        SCALL    SSSS - H'200   ; 2E
LLLL:   SCALL    SSSS - H'100   ; 2F

SSSS:   JBC      AX,0,LLLL      ; 30
        JBC      AX,1,LLLL      ; 31
        JBC      AX,2,LLLL      ; 32
        JBC      AX,3,LLLL      ; 33
        JBC      AX,4,LLLL      ; 34
        JBC      AX,5,LLLL      ; 35
        JBC      AX,6,LLLL      ; 36
        JBC      AX,7,LLLL      ; 37
        JBS      AX,0,LLLL      ; 38
        JBS      AX,1,LLLL      ; 39
        JBS      AX,2,LLLL      ; 3A
        JBS      AX,3,LLLL      ; 3B
        JBS      AX,4,LLLL      ; 3C
        JBS      AX,5,LLLL      ; 3D
        JBS      AX,6,LLLL      ; 3E
        JBS      AX,7,LLLL      ; 3F

        AND      AX,BX,CX       ; 40
        AND      AX,BX,#NNNN    ; 41
        AND      AX,BX,[CX]     ; 42
        AND      AX,BX,NN[CX]   ; 43
        ADD      AX,BX,CX       ; 44
        ADD      AX,BX,#NNNN    ; 45
        ADD      AX,BX,[CX]     ; 46
        ADD      AX,BX,NNNN[CX] ; 47
        SUB      AX,BX,CX       ; 48
        SUB      AX,BX,#NNNN    ; 49
        SUB      AX,BX,[CX]     ; 4A
        SUB      AX,BX,NNNN[CX] ; 4B
        MULU     AX,BX,CX       ; 4C
        MULU     AX,BX,#NNNN    ; 4D
        MULU     AX,BX,[CX]     ; 4E
        MULU     AX,BX,NNNN[CX] ; 4F

        ANDB     AX,BX,CX       ; 50
        ANDB     AX,BX,#NN      ; 51
        ANDB     AX,BX,[CX]     ; 52
        ANDB     AX,BX,NNNN[CX] ; 53
        ADDB     AX,BX,CX       ; 54
        ADDB     AX,BX,#NN      ; 55
        ADDB     AX,BX,[CX]     ; 56
        ADDB     AX,BX,NNNN[CX] ; 57
        SUBB     AX,BX,CX       ; 58
        SUBB     AX,BX,#NN      ; 59
        SUBB     AX,BX,[CX]     ; 5A
        SUBB     AX,BX,NNNN[CX] ; 5B
        MULUB    AX,BX,CX       ; 5C
        MULUB    AX,BX,#NN      ; 5D
        MULUB    AX,BX,[CX]     ; 5E
        MULUB    AX,BX,NNNN[CX] ; 5F

        AND      AX,BX          ; 60
        AND      AX,#NNNN       ; 61
        AND      AX,[BX]        ; 62
        AND      AX,NNNN[BX]    ; 63
        ADD      AX,BX          ; 64
        ADD      AX,#NNNN       ; 65
        ADD      AX,[BX]        ; 66
        ADD      AX,NNNN[BX]    ; 67
        SUB      AX,BX          ; 68
        SUB      AX,#NNNN       ; 69
        SUB      AX,[BX]        ; 6A
        SUB      AX,NNNN[BX]    ; 6B
        MULU     AX,BX          ; 6C
        MULU     AX,#NNNN       ; 6D
        MULU     AX,[BX]        ; 6E
        MULU     AX,NNNN[BX]    ; 6F

        ANDB     AX,BX          ; 70
        ANDB     AX,#NN         ; 71
        ANDB     AX,[BX]        ; 72
        ANDB     AX,NNNN[BX]    ; 73
        ADDB     AX,BX          ; 74
        ADDB     AX,#NN         ; 75
        ADDB     AX,[BX]        ; 76
        ADDB     AX,NNNN[BX]    ; 77
        SUBB     AX,BX          ; 78
        SUBB     AX,#NN         ; 79
        SUBB     AX,[BX]        ; 7A
        SUBB     AX,NNNN[BX]    ; 7B
        MULUB    AX,BX          ; 7C
        MULUB    AX,#NN         ; 7D
        MULUB    AX,[BX]        ; 7E
        MULUB    AX,NNNN[BX]    ; 7F

        OR      AX,BX           ; 80
        OR      AX,#NNNN        ; 81
        OR      AX,[BX]         ; 82
        OR      AX,NNNN[BX]     ; 83
        XOR     AX,BX           ; 84
        XOR     AX,#NNNN        ; 85
        XOR     AX,[BX]         ; 86
        XOR     AX,NNNN[BX]     ; 87
        CMP     AX,BX           ; 88
        CMP     AX,#NNNN        ; 89
        CMP     AX,[BX]         ; 8A
        CMP     AX,NNNN[BX]     ; 8B
        DIVU    AX,BX           ; 8C
        DIVU    AX,#NNNN        ; 8D
        DIVU    AX,[BX]         ; 8E
        DIVU    AX,NNNN[BX]     ; 8F

        ORB     AX,BX           ; 90
        ORB     AX,#NN          ; 91
        ORB     AX,[BX]         ; 92
        ORB     AX,NNNN[BX]     ; 93
        XORB    AX,BX           ; 94
        XORB    AX,#NN          ; 95
        XORB    AX,[BX]         ; 96
        XORB    AX,NNNN[BX]     ; 97
        CMPB    AX,BX           ; 98
        CMPB    AX,#NN          ; 99
        CMPB    AX,[BX]         ; 9A
        CMPB    AX,NNNN[BX]     ; 9B
        DIVUB   AX,BX           ; 9C
        DIVUB   AX,#NN          ; 9D
        DIVUB   AX,[BX]         ; 9E
        DIVUB   AX,NNNN[BX]     ; 9F

        LD       AX,BX          ; A0
        LD       AX,#NNNN       ; A1
        LD       AX,[BX]        ; A2
        LD       AX,NNNN[BX]    ; A3
        ADDC     AX,BX          ; A4
        ADDC     AX,#NNNN       ; A5
        ADDC     AX,[BX]        ; A6
        ADDC     AX,NNNN[BX]    ; A7
        SUBC     AX,BX          ; A8
        SUBC     AX,#NNNN       ; A9
        SUBC     AX,[BX]        ; AA
        SUBC     AX,NNNN[BX]    ; AB
        LDBZE    AX,BX          ; AC
        LDBZE    AX,#NN         ; AD
        LDBZE    AX,[BX]        ; AE
        LDBZE    AX,NNNN[BX]    ; AF

        LDB      AX,BX          ; B0
        LDB      AX,#NN         ; B1
        LDB      AX,[BX]        ; B2
        LDB      AX,NNNN[BX]    ; B3
        ADDCB    AX,BX          ; B4
        ADDCB    AX,#NN         ; B5
        ADDCB    AX,[BX]        ; B6
        ADDCB    AX,NNNN[BX]    ; B7
        SUBCB    AX,BX          ; B8
        SUBCB    AX,#NN         ; B9
        SUBCB    AX,[BX]        ; BA
        SUBCB    AX,NNNN[BX]    ; BB
        LDBSE    AX,BX          ; BC
        LDBSE    AX,#NN         ; BD
        LDBSE    AX,[BX]        ; BE
        LDBSE    AX,NNNN[BX]    ; BF

        ST       AX,BX          ; C0
;       BMOV     AX,BX          ; C1 (8XC196KB)
        ST       AX,[BX]        ; C2
        ST       AX,NNNN[BX]    ; C3
        STB      AX,BX          ; C4
;       CMPL     AX,BX          ; C5 (8XC196KB)
        STB      AX,[BX]        ; C6
        STB      AX,NNNN[BX]    ; C7
        PUSH     AX             ; C8
        PUSH     #NNNN          ; C9
        PUSH     [AX]           ; CA
        PUSH     NNNN[AX]       ; CB
        POP      AX             ; CC
;       BMOVI    AX,BX          ; CD (8XC196KB)
        POP      [AX]           ; CE
MMMM:   POP      NN[AX]         ; CF

        JNST     MMMM           ; D0
        JNH      MMMM           ; D1
        JGT      MMMM           ; D2
        JNC      MMMM           ; D3
        JNVT     MMMM           ; D4
        JNV      MMMM           ; D5
        JGE      MMMM           ; D6
        JNE      MMMM           ; D7
        JST      MMMM           ; D8
        JH       MMMM           ; D9
        JLE      MMMM           ; DA
        JC       MMMM           ; DB
        JVT      MMMM           ; DC
        JV       MMMM           ; DD
        JLT      MMMM           ; DE
        JE       MMMM           ; DF

        DJNZ     AX,MMMM        ; E0
;       DJNZW    AX,MMMM        ; E1 (8XC196KB)
;       TIJMP    AX,[BX],#NN    ; E2 (8XC196KB)
        BR       [AX]           ; E3
        .db      H'E4           ; E4
        .db      H'E5           ; E5
        .db      H'E6           ; E6
        LJMP     MMMM           ; E7
        .db      H'E8           ; E8
        .db      H'E9           ; E9
        .db      H'EA           ; EA
        .db      H'EB           ; EB
;       DPTS                    ; EC (8XC196KB)
;       EPTS                    ; ED (8XC196KB)
        .db      H'EE           ; EE
        LCALL    MMMM           ; EF

        RET                     ; F0
        .db      H'F1           ; F1
        PUSHF                   ; F2
        POPF                    ; F3
;       PUSHA                   ; F4 (8XC196KB)
;       POPA                    ; F5 (8XC196KB)
;       IDLPD    #NN            ; F6 (8XC196KB)
;       TRAP                    ; F7
        CLRC                    ; F8
        SETC                    ; F9
        DI                      ; FA
        EI                      ; FB
        CLRVT                   ; FC
        NOP                     ; FD
;
;  Signed Multiply and Divide   ; FE

        MUL    AX,BX,CX         ; FE4C
        MUL    AX,BX,#NNNN      ; FE4D
        MUL    AX,BX,[CX]       ; FE4E
        MUL    AX,BX,NNNN[CX]   ; FE4F
        MULB   AX,BX,CX         ; FE5C
        MULB   AX,BX,#NN        ; FE5D
        MULB   AX,BX,[CX]       ; FE5E
        MULB   AX,BX,NNNN[CX]   ; FE5F
        MUL    AX,BX            ; FE6C
        MUL    AX,#NNNN         ; FE6D
        MUL    AX,[BX]          ; FE6E
        MUL    AX,NNNN[BX]      ; FE6F
        MULB   AX,BX            ; FE7C
        MULB   AX,#NN           ; FE7D
        MULB   AX,[BX]          ; FE7E
        MULB   AX,NNNN[BX]      ; FE7F
        DIV    AX,BX            ; FE8C
        DIV    AX,#NNNN         ; FE8D
        DIV    AX,[BX]          ; FE8E
        DIV    AX,NNNN[BX]      ; FE8F
        DIVB   AX,BX            ; FE9C
        DIVB   AX,#NN           ; FE9D
        DIVB   AX,[BX]          ; FE9E
        DIVB   AX,NNNN[BX]      ; FE9F

        RST                     ; FF
        .end    TESTER

