/*
makecsv <filename>

This program looks at 2 input files and creates a third file.
The user provides the basename of the files (8 character maximum,
no extension.

The program then looks for:
<filename>.dat which should be 512 bytes long, binary data from meter
<filename>.hdr which contains an ASCII text header

and creates
<filename>.csv which is a a 512 line file with the x value,yvalue
for each data point on a separate line.

Program exits with 1 if an error occured, 0 if ok.
*/

/* external program to process binary fluke data to csv files */
/* V1.1, fixed problem with reading a null data file */
/* V1.2, added additional documentation, changed error returns for exit() */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

main (int argc, char **argv, char**envp)
{
	/* used for building up strings */
	char tmpstr[80];

	/* the .hdr values are read into here */
	char id[80],yunit[80],xunit[80];
	double yzero,xzero,ydelta,xdelta;
	int ylevel,xsample;

	/* data is put here */
	unsigned char values[512];
	int counter;

	/* calculated values for csv file */
	double realx,realy;

	/* file pointer */
	FILE *infile;

	int reterror;

	/* build up the name of the .hdr file */
	sprintf(tmpstr, "%s.hdr", argv[1]);
	if ((infile=fopen(tmpstr, "rb")) == NULL)
	{
		printf("ERROR: can't find file %s\n", tmpstr);
		exit(1);
	}

	/* please note that this file IS NOT free format */
	/* in fact, the numeric quantities must come first since this */
	/* routine depends on the 'terminate at whitespace' property */
	/* of atof and atoi */
	fgets(id,80,infile);
	fgets(xunit,80,infile);
	fgets(yunit,80,infile);
	fgets(tmpstr,80,infile);
	xzero=atof(tmpstr);
	fgets(tmpstr,80,infile);
	yzero=atof(tmpstr);
	fgets(tmpstr,80,infile);
	xdelta=atof(tmpstr);
	fgets(tmpstr,80,infile);
	ydelta=atof(tmpstr);
	fgets(tmpstr,80,infile);
	xsample=atoi(tmpstr);
	fgets(tmpstr,80,infile);
	ylevel=atoi(tmpstr);
	fclose(infile);

	/* get the data file */
	sprintf(tmpstr, "%s.dat", argv[1]);
	if ((infile=fopen(tmpstr, "rb")) == NULL)
	{
		printf("ERROR: can't find file %s\n", tmpstr);
		exit(1);
	}
	if (512 != fread((void *)values, sizeof(char), 512, infile))
	{
		printf("ERROR: improper data format in %s\n", tmpstr);
		exit(1);
	}
	fclose(infile);

	/* write it out */
	sprintf(tmpstr, "%s.csv", argv[1]);
	if ((infile=fopen(tmpstr, "wb")) == NULL)
	{
		printf("ERROR: can't write file %s\n", tmpstr);
		exit(1);
	}
	for(counter=0;counter<512;counter++)
	{
		realx = ((float)counter * xdelta) + xzero;
		realy = (((float)values[counter] - 128.0) * ydelta) - yzero;
		fprintf (infile,"%.3e,%.3e\n",realx,realy);
	}
	fclose(infile);
	exit(0);
}
