#include <windows.h>

LPSTR	AppName			= "SAMPLE";
#define	AM_DROP_OK		15669
#define AM_DROP_DATE	16763

LRESULT CALLBACK _export MainWndProc( HWND, unsigned, WORD, LONG );

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow )
{
    HWND hWnd;
    MSG msg;
    WNDCLASS wndClass;

    if( !hPrevInstance ) {
		wndClass.style = CS_HREDRAW | CS_VREDRAW;
		(FARPROC)wndClass.lpfnWndProc = (FARPROC)MainWndProc;
		wndClass.cbClsExtra = 0;
		wndClass.cbWndExtra = 0;
		wndClass.hInstance = hInstance;
		wndClass.hIcon = LoadIcon( NULL, IDI_APPLICATION );
		wndClass.hCursor = LoadCursor( NULL, IDC_ARROW );
		wndClass.hbrBackground = COLOR_WINDOW + 1;
		wndClass.lpszMenuName = NULL;
		wndClass.lpszClassName = AppName;

		RegisterClass( &wndClass );
	}
    
    hWnd = CreateWindow( AppName, AppName, WS_OVERLAPPEDWINDOW,  CW_USEDEFAULT,
                CW_USEDEFAULT, 270, 120, NULL, NULL, hInstance, NULL );


    ShowWindow(hWnd,nCmdShow);
    UpdateWindow(hWnd);

    while ( GetMessage( &msg, NULL, 0, 0 ) ){
        	TranslateMessage( &msg );
        	DispatchMessage( &msg );
    }

    return msg.wParam;
}

LRESULT CALLBACK _export MainWndProc( HWND hWnd, unsigned iMessage,
                                     WORD wParam, LONG lParam )
{
    static HINSTANCE hInstance;
    static HWND hWndEdit;
    
    switch( iMessage )
    {
    	case WM_CREATE:
    		hInstance = ( (LPCREATESTRUCT) lParam ) -> hInstance;
			hWndEdit = CreateWindow( "EDIT", "", 
			WS_CHILD | WS_VISIBLE | WS_BORDER | ES_AUTOHSCROLL, 
				10, 65, 250, 25, hWnd, 100, hInstance, NULL );
			CreateWindow( "STATIC", (LPSTR) "Drag the date from the "
				"DateFind window and drop into the field below:", WS_CHILD | 
				WS_VISIBLE , 10, 10, 250, 50, hWnd, 0, hInstance, NULL );
            return 0;                  
		case AM_DROP_OK:
			if( wParam == hWndEdit )
				return TRUE;
			return FALSE;
		case AM_DROP_DATE:
			if( wParam == hWndEdit )
				SetWindowText( hWndEdit, (LPSTR) lParam );
			return TRUE;
		case WM_DESTROY:
			PostQuitMessage( 0 );
			return 0;
	}
	
	return DefWindowProc( hWnd, iMessage, wParam, lParam );
}
