/*
   HELPDLL.C - WinHelp DLLs helper functions

   Copyright 1994, Jim Mischel
*/
#include <windows.h>
#include <malloc.h>
#include <string.h>
#include "helpdll.h"

static whDLLStruc ModuleList = {0, NULL, NULL};
static whDLLPtr CurrentModule = &ModuleList;

// internal linked list routines

static void llPrepend (whDLLPtr p) {
  p->Next = ModuleList.Next;
  ModuleList.Next = p;
}

static whDLLPtr llFind (unsigned s) {
  whDLLPtr q = ModuleList.Next;

  while (q != NULL && q->StackSeg != s) q = q->Next;
  return q;
}

static void llUnlink (whDLLPtr p) {
  whDLLPtr q = &ModuleList;

  while (q->Next != p) q = q->Next;
  q->Next = p->Next;
}

static void llFree (whDLLPtr p, whDLLFreeFunc Func) {
  llUnlink (p);
  // free any other memory used by this DLL
  if (Func != NULL)
    Func (p->Extra);
  else if (p->Extra != NULL)
    free (p->Extra);
  free (p->FPtrs);
  free (p);
}

whDLLPtr far pascal GetCurrentModule (void) {
#ifndef __BORLANDC__
  unsigned _SS;
  asm mov _SS,ss
#endif
  if (CurrentModule->StackSeg != _SS)
    if ((CurrentModule = llFind (_SS)) == NULL) {
      CurrentModule = malloc (sizeof (whDLLStruc));
      CurrentModule->StackSeg = _SS;
      CurrentModule->Extra = NULL;
      CurrentModule->Next = NULL;
      CurrentModule->FPtrs = malloc (VPTR_Size);
      llPrepend (CurrentModule);
    }
  return CurrentModule;
}

// GetWinHelpCallbacks -- Copy WinHelp internal function pointers
BOOL far pascal GetWinHelpCallbacks (VPTR VPtr, long lVersion) {
  memmove (GetCurrentModule()->FPtrs, VPtr, VPTR_Size);
  return TRUE;
}

// EndWinHelpDLL -- Free memory used by this instance
void far pascal EndWinHelpDLL (whDLLFreeFunc Func) {
  llFree (GetCurrentModule (), Func);
  CurrentModule = &ModuleList;
}

/*
   LGetHPath -- Get path of current help file and return new
   allocated string.  This function calls LGetInfo() and then
   copies the returned string to a new pointer, which is returned.
   The handle returned by LGetInfo() is deallocated.  The routine
   that calls LGetHPath() is responsible for free()ing the
   pointer that LGetHPath() returns.
*/
char far * LGetHPath (HWND wnd) {
  HGLOBAL Handle = (HGLOBAL)LGetInfo (GI_HPATH, wnd);
  char far *c = GlobalLock (Handle);
  char far *fname = NULL;

  if (c != NULL) {
    fname = strdup (c);
    GlobalUnlock (Handle);
    GlobalFree (Handle);
  }
  return fname;
}
