/*
 * Audio Handler
 *
 * Copyright (c) 1992,1995 by Martin Brenner
 *
 * THIS INFORMATION IS PROVIDED "AS IS"; NO WARRANTIES ARE MADE.
 * ALL USE IS AT YOUR OWN RISK, AND NO LIABILITY OR 
 * RESPONSIBILITY IS ASSUMED.
 *
 * Data structures and prototypes
 *
 * $Header: Work:Progs/aud/RCS/audio.h,v 1.3 1995/08/01 03:05:47 martin Exp martin $
 *
 * $Log: audio.h,v $
 * Revision 1.3  1995/08/01  03:05:47  martin
 * Bug fixes for version 1.0 beta
 *
 * Revision 1.2  1995/07/19  10:05:40  martin
 * first release version, 1.0 beta
 *
 * Revision 1.1  1995/07/04  20:05:03  martin
 * Initial revision
 *
 */
/*
 * There are two buffers of size AUDIOBUFSIZE (double buffering).
 * The requirement is that the size be a multiple of 2.
 */
#define AUDIOBUFSIZE (32*1024) /* 32kB buffers */
#define CLOCK_CONSTANT_NTSC 3579545L
#define CLOCK_CONSTANT_PAL 3546895L
#define DEFAULT_FREQUENCY 8000L
#define DEFAULT_PERIOD (CLOCK_CONSTANT_PAL/DEFAULT_FREQUENCY)
#define DEFAULT_VOLUME 64

struct AudioOptions {
	WORD	AO_Priority;		/* Audio priority */
	WORD	AO_NumChannels;		/* number of possible channels */
	UBYTE	*AO_Channels;		/* list of possible channel combinations */
	LONG	AO_BufferSize;		/* size of audio buffers */
	LONG	AO_Period;			/* Period */
	LONG	AO_Debug;			/* Generate debugging - set debug number */
	WORD	AO_Volume;			/* Volume */
};

struct AudioBuffer {
	UBYTE	*AB_Data;	/* buffer itself */
	LONG	AB_Size;	/* length of buffer */
	LONG	AB_End;		/* End of actual data in buffer */
	WORD	AB_InUse;	/* Is the buffer currently used by audio.device? */
};

struct AudioState {
	struct List AS_ReadyQueue;	/* Queue for incoming write request packets, holds messages */
	LONG	AS_BytesCopied;		/* bytes already copied from current write packet to audio buffer */
	LONG	AS_OpenForOutput;	/* Has the device been opened ? */
	struct AudioOptions AS_Options;	/* Audio Options */
	struct AudioBuffer AS_Buffer1;
	struct AudioBuffer AS_Buffer2;
	struct AudioBuffer *AS_CurrentBuffer;	/* buffer currently played by audio.device */
	struct AudioBuffer *AS_NextBuffer;		/* buffer being filled with data */
	WORD	AS_AllocState;		/* allocation request status */
	WORD	AS_LockState;		/* lock status */
	struct IOAudio *AS_AllocIO;	/* iob used for allocating channel(s) */
	struct IOAudio *AS_LockIO;	/* iob used for locking */
	struct IOAudio *AS_IO1;		/* iob used for Buffer1 */
	struct IOAudio *AS_IO2;		/* iob used for Buffer2 */
	struct IOAudio *AS_CurrentIO;	/* iob currently played by audio.device */
	struct IOAudio *AS_NextIO;		/* iob for buffer being filled with data */
	struct DosPacket AS_DummyPacket;	/* Dummy packet used for IO-requests */
	struct FileHandle *AS_FileHandle;	/* FileHandle for current DOS-IO */ 
};

/* Allocation State values */
#define ALLOCSTATE_UNUSED		1	/* nothing done yet */
#define ALLOCSTATE_ALLOCATING	2	/* allocation request sent, but not yet satisfied */
#define ALLOCSTATE_ALLOCATED	3	/* allocation request satisfied, channel(s) are allocated */
#define ALLOCSTATE_FREEING		4	/* free request sent, but not yet returned */
#define ALLOCSTATE_STOLEN		5	/* channel(s) stolen by another process */

/* Lock States */
#define LOCKSTATE_UNUSED		1	/* not yet sent */
#define LOCKSTATE_LOCKED		2	/* locking request sent, and not yet replied */

/* Prototypes for external functions */
void __stdargs KPrintF(const char *, ...);
