
{$I-}   {I/O checking must be off.}

program setini;

uses dos,strings;

{  Program to make automated modifications to Windows style .INI files.  }

const {initialised variables}
  status  : (looking, in_section, done) = looking;
  oldline : string = '';                              {line to search for}
  newline : string = '';                              {line to substitute, or
                                                         blank for delete}
var

  filename      : string;                             {file name to process}
  section       : string;                             {file section to find}
  keyname       : string;                             {keyname to find}
  value         : string;                             {new value}
  arg           : string;                             {may be /add or /del}
  thisline      : string;                             {current line}
  tempfile      : pathstr;                            {temp file name}
  dir           : dirstr;                             {components of temp}
  name          : namestr;
  ext           : extstr;
  inputfile, outputfile : text;


procedure syntaxerror;

  begin
    writeln('SETINI Windows Configuration Changer v1.6b - (C) Cardiology Dept, RMH.');
    writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au> - 8 July 95');
    writeln;
    writeln('SYNTAX: SETINI <file> <section> <keyname> <value> <option>');
    writeln;
    writeln('  eg. SETINI system 386Enh TimerCriticalSection 10000');
    writeln('      SETINI win.ini "Microsoft Word 2.0" DOC-path h:\');
    writeln('      SETINI d:system.ini 386Enh device *vtd /del');
    writeln('      SETINI c:\win31\system.ini 386Enh device vtda.386 /add');
    writeln('      SETINI c:\config.sys "" files 50');
    halt(1);
  end;


procedure raiserror(exitcode:word; message:string);

begin
  writeln(message);
  halt(exitcode);
end;


function nextarg:string;

{retrieves the next arguement from command line, using quotes for delimiting}

const param : integer = 1;            {use for parsing command line}
var   arg : string;

begin
  arg := paramstr(param);
  param := param + 1;
  if arg[1] = '"' then
    begin
      delete(arg,1,1);                        {delete starting quote}
      while (arg[length(arg)] <> '"') do
        begin
        if param > paramcount then syntaxerror;
        arg := arg + ' ' + paramstr(param);
        param := param + 1;
      end;
      delete(arg,length(arg),1);              {delete ending quote}
    end;
  nextarg := arg;
end;


function match(string1,string2:string):boolean;

var i,strlen : integer;

begin
  strlen := length(string1);
  if (length(string2) < strlen) or
    ((length(string2) > strlen) and (string1[strlen] <> '=')) then
      begin
        match := false;
        exit;
      end;

  for i:=1 to strlen do
    if upcase(string1[i]) <> upcase(string2[i]) then
      begin
        match:=false;
        exit;
      end;

  match:=true;
end;


procedure writeout(line:string);

{write a line to output file and check the result}

begin
  writeln(outputfile,line);
  if IOresult<>0 then raiserror(5,'Can''t write to file '+tempfile+'.');
end;


begin {program}

  if paramcount<4 then syntaxerror;

  filename:=nextarg;
  fsplit(filename,dir,name,ext);

  if dir = '' then
    dir := 'c:\windows\'
  else if (length(dir)=2) and (dir[2]=':') then
    dir := dir + '\windows\';

  if ext = '' then ext := '.ini';

  filename := dir + name + ext;
  tempfile := dir + name + '.$$$';

  assign(inputfile, filename);               {open input file}
  reset(inputfile);
  if IOresult<>0 then
    raiserror(2,'Can''t open for reading file '+filename+'.');

  section := nextarg;
  if section = '' then begin
    status := in_section;
    section := 'preface';
  end else
    if section[1] <> '[' then section := '[' + section + ']';

  keyname := nextarg;
  if keyname = '' then syntaxerror;

  value := nextarg;

  repeat
    arg := nextarg;

    if arg = '' then begin
      oldline := keyname+'=';
      newline := keyname+'='+value;
    end else if match('/add',arg) then begin
      oldline := keyname+'='+value;
      newline := keyname+'='+value;
    end else if match('/del',arg) then begin
      oldline := keyname+'='+value;
      newline := '';
    end else value := value + ' ' + arg;

  until oldline <> '';

  assign(outputfile, tempfile);
  rewrite(outputfile);
  if IOresult<>0 then
    raiserror(3,'Can''t open for writing file '+tempfile+'.');

  while(not eof(inputfile)) do
    begin
      readln(inputfile,thisline);               {read a line from input file}
      if IOresult<>0 then
        raiserror(4,'Can''t read from file '+filename+'.');

      { strip starting and trailing spaces }
      while (length(thisline)>0) and (thisline[1] = ' ') do
        delete(thisline,1,1);
      while (length(thisline)>0) and (thisline[length(thisline)] = ' ') do
        delete(thisline,length(thisline),1);

      if thisline[1] = '[' then                 {we've started a new section}
        case status of
          looking:
            if match(section,thisline) then
              status := in_section;
          in_section:
            begin
              if newline<>'' then begin
                writeout(newline);
                writeln('"'+newline+'" added to '+section+' section of '
                  +filename+'.');
              end else
                writeln('"'+oldline+'" not found in '+section+' section of '
                  +filename+'.');
              status:=done;
            end;
        end;

      if (status = in_section) and match(oldline,thisline) then {do our stuff}
        begin
          if newline='' then
            writeln('"'+oldline+'" deleted from '+section+' section of '
              +filename+'.')
          else
            begin
              writeout(newline);
              writeln('"'+newline+'" set in '+section+' section of '
                +filename+'.');
            end;
          status:=done;
        end
      else if thisline <> '' then          {otherwise just write out the line}
        begin
          if thisline[1] = '[' then writeout('');
          writeout(thisline);
        end;
    end;                                            {end of main loop}

  if newline <> '' then
    case status of
      looking:
        begin
          writeout('');
          writeout(section);
          writeout(newline);
          writeln('"'+newline+'" added to new '+section+' section of '
            +filename+'.');
        end;
      in_section:
        begin
          writeout(newline);
          writeln('"'+newline+'" added to '+section+' section of '
            +filename+'.');
        end;
    end else {newline=''}
      if status <> done then
        writeln('"'+oldline+'" not found in '+section+' section of '
          +filename+'.');

  close(inputfile);
  close(outputfile);

  erase(inputfile);

  if IOResult<>0 then
    raiserror(6,'Couldn''t delete old version of '+filename+'.');

  rename(outputfile,filename);

  if IOResult<>0 then
    raiserror(7,'Couldn''t rename temporary file '+tempfile+'.');

end.
