Listing4

//////// AB CLASSGEN Mon May 01 09:37:31 1995 ////////
// MODALDLG, the letter in the SHOWDATA envelope
//////////////////////////////////////////////////////
#if !defined(MODALDLG_HPP)
#define MODALDLG_HPP
#if !defined(RC_INVOKED)    // no Windows RC compiler
#include "SHOWDATA.HPP"
#include "LINEIN.HPP"
#include "CTL.HPP"

class MODALDLG : public CTLMAPPER {
public:
    MODALDLG(SHOWDATA *Guru,
            HWND hWndParent, HINSTANCE hInst,
            const char szDescrFile[],
            const char szDescrSect[],
            const char szResourceType[] = 0
            );
    virtual ~MODALDLG();

    CTL* virtualCTLCtor(const DESCRIPT& Desc);
        // overload to have new controls,
        // yet call MODALDLG::'s from derived

    SHOWDATA::RET isValid() const { return _valid; }
    SHOWDATA::RET run();

    virtual BOOL proc(UINT iMsg, WPARAM wParam,
                        LPARAM lParam);

    static const int DUXMARGIN;
    static const int DUYMARGIN;

    enum { CTABSIZE = 256 };

typedef struct GCTLTag {
    int group;
    CTL * ctl;
    } GCTL;

typedef struct GRPXYTag {
    STR name;
    int duwLabel, duhLabel;
    int duwAll, duhAll;
    int duxNext, duyNext;
    } GRPXY;

typedef struct DLGHEADERTag {
    long  dtStyle;
    BYTE  dtItemCount;
    int   dtX;
    int   dtY;
    int   dtCX;
    int   dtCY;
    char  dtMenuName[1];
    char  dtClassName[1];
    char  dtCaptionText[1];
    WORD  wPointSize;
    char  szFaceName[14];
    } DLGHEADER;

private:
    SHOWDATA *_guru;
    const HINSTANCE _hI;
    const HWND _hP;
    const STR _dsect;
    LINEIN _input;
    DESCRIPT _dlgline;
    MEMBLOCK _template;
    GCTL _ctab[CTABSIZE];
    GRPXY *_pGXY;
    int _ng;
    int _nCtls, _xOffset;
    HWND _hDlg;
    HFONT _hThinFont;
    int _nActiveGroup;
    SHOWDATA::RET _valid;

// MODAL0.CPP:
    int _addCtlToDlg(const DESCRIPT& Desc, int xCtl);
        // returns # of added items

// MODAL1.CPP:
    static const DLGHEADER _DlgHd;
    static const CTL::DLGITEM _ItemOk;
    static const CTL::DLGITEM _ItemCan;
    static const CTL::DLGITEM _ItemGroup;
    BOOL _initGeometry();
    void _addToGroupGeometry(int nGrp,
                    int duW, int duH);
    void _putTabsAndOKCAN();

    virtual int duwText(const char szS[],
                    BOOL bForButton = FALSE) const;
    virtual int duhText() const;
    virtual int duhEdit() const;
    virtual int duhPush() const;
    virtual int duSquareBox() const;
    virtual int duwScreen () const;
    virtual int duhScreen () const;

// MODAL2.CPP:
    // The this <---> HWND bijection story:
    static MODALDLG* HWIN2this(HWND hWnd){
            return (MODALDLG*) (MAKELPARAM(
                            GetProp(hWnd, A_LPTR),
                            GetProp(hWnd, A_HPTR)));
                            }
    static const char far A_HPTR[];
    static const char far A_LPTR[];
    static BOOL CALLBACK _export _DlgProc(HWND hWnd,
            UINT iMsg, WPARAM wParam, LPARAM lParam);
    void _forceActiveGroup(int nG);
    void _setActiveGroup(int nG);
    void _endDialog(SHOWDATA::RET Result);

//MODAL3.CPP:
    void _thinFontJob();
    void _drawTab(LPDRAWITEMSTRUCT lpDraw);
    void _centerOnScreen();

// no body, forbidden use:
    MODALDLG();
    MODALDLG(const MODALDLG&);
    MODALDLG& operator=(const MODALDLG&);
};
#endif
#endif
