/////////////////////////////////////////////////////
//	DESCRIPT implementation
/////////////////////////////////////////////////////
#include "DESCRIPT.HPP"
#include <stdlib.h>

DESCRIPT::DESCRIPT(const char szS[]) : STR (szS){}
DESCRIPT::~DESCRIPT() {}

short DESCRIPT::isSep(int c, int k) const
{
if(operator[](k) != c)
	return 0;
if(k == 0)
	return 1;
return operator[](k-1) != LIT;
}

const char * DESCRIPT::retVal(STR& _buf) const
{
int i, j;
char *p = (char*)(const char*)_buf;

for(i = 0; p[i]; i++){
	if(p[i] == LIT){
		for(j = i; p[j]; j++)
			p[j] = p[j+1];
		}
	}
return p;
}

const char * DESCRIPT::type(STR& _buf) const
{
_buf = "";
short i = hasin(SLASH);
if(i == -1){
	_buf = *this;
	return retVal(_buf);
	}
for(short j = 0; j < i; j++)
	_buf += operator[](j);
return retVal(_buf);
}

const char * DESCRIPT::value(const char szParam[],
							STR& _buf) const
{
short last, i, j;
_buf = "";
i = 0;
for(last = 0 ; -1 != (i = hasin(SLASH, last+1)) ;
									last = i){
	if(!isSep(SLASH, i))
		continue;
	if(i+1 == hasin(szParam, i)){
		for(short k = i+1 ;
			operator[](k) && !isSep(SLASH, k)
							&& !isSep(EQUAL,k) ;
			k++)
			;
		if(isSep(EQUAL, k)){
			for(j = k+1 ; operator[](j)
							&& !isSep(SLASH, j); j++)
				_buf += operator[](j);
			return retVal(_buf);
			}
		}
	}
return 0;
}

int DESCRIPT::value(const char szParam[], int nDef)
					const
{
STR _buf;
if(0 == value(szParam, _buf))
	return nDef;
return atoi(retVal(_buf));
}


void DESCRIPT::setType(const char szType[])
{
*(STR*)this = szType;
}

void DESCRIPT::addParam(const char szParam[],
					const char szValue[])
{
*this += SLASH;
*this += szParam;
*this += EQUAL;
for(int i = 0; szValue[i]; i++){
	if(szValue[i] == SLASH || szValue[i] == EQUAL ||
						szValue[i] ==  LIT)
		*this += LIT;
	*this += szValue[i];
	}
}

void DESCRIPT::addParam(const char szParam[],
						int nValue)
{
STR _buf(20);
itoa(nValue, (char*)(const char*)_buf, 10);
*this += SLASH;
*this += szParam;
*this += EQUAL;
*this += _buf;
}


MULTIPARAM::MULTIPARAM(const DESCRIPT* Desc,
					const char szMP[])
	: _desc(Desc), _mp(szMP)
{
STR Buf;
int i;
for(i = 0; 0 != _desc->value(_makeParam(i), Buf);
	i++)
	;
_n = i;
}

const char* MULTIPARAM::value(int x, STR& Buf)
{
if(x < 0 || _n <= x)
	return 0;
return _desc->value(_makeParam(x), Buf);
}

int MULTIPARAM::value(int x, int nDefVal)
{
if(x < 0 || _n <= x)
	return 0;
return _desc->value(_makeParam(x), nDefVal);
}

const char* MULTIPARAM::_makeParam(int index)
{
char sz[16];
itoa(index, sz, 10);
_full = _mp;
_full += sz;
return _full;
}


