//////// AB CLASSGEN Sat Apr 29 04:23:36 1995 ////////
// CTL, an abstract control
//////////////////////////////////////////////////////
#if !defined(CTL_HPP)
#define CTL_HPP
#if !defined(RC_INVOKED)	// no Windows RC compiler
#include "SHOWDATA.HPP"
#include "DESCRIPT.HPP"
#include "MEMBLOCK.HPP"

class CTL {
public:
	CTL(const DESCRIPT& Desc, SHOWDATA * Guru)
			: _desc(Desc), _guru(Guru) { _hDlg = 0; }
	virtual ~CTL() {}

	// these values should be computed on ctor:
	int duW() { return _duw; }
	int duH() { return _duh; }

	virtual int addToDlg(int nFirstFreeId,
						MEMBLOCK *pTemplateSoFar,
						int duX, int duY) = 0;
					// returns # of dialog items added

	void initScreen(HWND hDlg){
			_hDlg = hDlg;
			dataToScreen();
			}
	virtual BOOL wm_command(int nId, int nCommand)
							{ return FALSE; }
	virtual BOOL isDataOk() { return TRUE; }
	virtual void saveData() = 0;

typedef struct DLGITEMTag {
	int   dtilX;
	int   dtilY;
	int   dtilCX;
	int   dtilCY;
	int   dtilID;
	long  dtilStyle;
	BYTE  dtilClass;
	char  dtilText[1];
	BYTE   dtilInfo;
	} DLGITEM;

protected:
	SHOWDATA* _guru;
	const DESCRIPT _desc;
	int _duh, _duw;
	HWND _hDlg;

	static const DLGITEM _Text;
	static const DLGITEM _Edit;
	static const DLGITEM _Check;
	static const DLGITEM _Combo;
	static const DLGITEM _Push;

	virtual void dataToScreen() = 0;

private:
	CTL();
	CTL(const CTL&);
	CTL& operator=(const CTL&);
};

class CTLMAPPER {
public:
	virtual int duwText(const char szS[],
			BOOL bForButton = FALSE) const = 0;
	virtual int duhText() const = 0;
	virtual int duhEdit() const = 0;
	virtual int duhPush() const = 0;
	virtual int duSquareBox() const = 0;
	virtual int duwScreen() const = 0;
	virtual int duhScreen() const = 0;
	};

inline int max( int a, int b){ return a>b?a:b; }
inline int min( int a, int b){ return a>b?b:a; }

#endif
#endif
