//////// AB CLASSGEN Sat Apr 29 04:23:36 1995 ////////
// The base controls
//////////////////////////////////////////////////////
#if !defined(CONTROLS_HPP)
#define CONTROLS_HPP
#if !defined(RC_INVOKED)	// no Windows RC compiler
#include "CTL.HPP"

// CTLEDIT, the edit control (and his static label)
class CTLEDIT : public CTL {
public:
	CTLEDIT(const DESCRIPT& Desc,
			SHOWDATA* Guru,
			const CTLMAPPER *Map);
	virtual ~CTLEDIT();

	virtual int addToDlg(int nFirstFreeId,
						MEMBLOCK *pTemplateSoFar,
						int duX, int duY);
	virtual BOOL wm_command(int nId, int nCommand);
	virtual BOOL isDataOk();
	virtual void saveData();

	// overload this in derived to check EN_CHANGE:
	virtual BOOL isOkOnTheFly(
			const char szContents[]) { return TRUE; }

protected:
	const CTLMAPPER * _map;
	int _idT, _idE;
	int _duwText, _duwEdit;
	BOOL _bInOneLine;
	STR _contents;
	virtual void dataToScreen();

private:
	CTLEDIT();
	CTLEDIT(const CTLEDIT&);
	CTLEDIT& operator=(const CTLEDIT&);
};

// CTLCHECK, the checkbox control
class CTLCHECK : public CTL {
public:
	CTLCHECK(const DESCRIPT& Desc,
			SHOWDATA* Guru,
			const CTLMAPPER *Map);
	~CTLCHECK();

	virtual int addToDlg(int nFirstFreeId,
						MEMBLOCK *pTemplateSoFar,
						int duX, int duY);
	virtual void saveData();

private:
	const CTLMAPPER * _map;
	int _idC;
	virtual void dataToScreen();

	CTLCHECK();
	CTLCHECK(const CTLCHECK&);
	CTLCHECK& operator=(const CTLCHECK&);
};

// CTLRADIO, the radio control (combo + static)
class CTLRADIO : public CTL {
public:
	CTLRADIO(const DESCRIPT& Desc,
			SHOWDATA * Guru,
			const CTLMAPPER *Map);
	~CTLRADIO();

	virtual int addToDlg(int nFirstFreeId,
						MEMBLOCK *pTemplateSoFar,
						int duX, int duY);
	virtual void saveData();

private:
	const CTLMAPPER * _map;
	int _idT, _idCB;
	int _duwText, _duwCombo;
	BOOL _bInOneLine;
	int _nR;
	virtual void dataToScreen();

	CTLRADIO();
	CTLRADIO(const CTLRADIO&);
	CTLRADIO& operator=(const CTLRADIO&);
};
#endif
#endif
