//////////////////////////////////////////////////////
// ASSOCMEM, an abstract data bank
//////////////////////////////////////////////////////
#if !defined(ASSOCMEM_HPP)
#define ASSOCMEM_HPP
#if !defined(RC_INVOKED)	// no Windows RC compiler
#include "STR.HPP"
class ASSOCMEM {
public:
	ASSOCMEM() {}
	virtual ~ASSOCMEM() {}

// get/set for strings:
	virtual const char* get(const char szSym[],
							STR& Val) const = 0;
		// returns Val, unchanged if szSym not found
	virtual void set(const char szSym[],
					const char szValue[])= 0;

// get/set for integers:
	virtual int get(const char szSym[],
					int nDefault = 0) const = 0;
	virtual void set(const char szSym[], int nVal)= 0;

private:
	ASSOCMEM(const ASSOCMEM&);
	ASSOCMEM& operator=(const ASSOCMEM&);
};
#endif
#endif
