{}
{                                                       }
{      Virtual Pascal Examples. Version 1.0.            }
{      WinDos unit test example.                        }
{      }
{      Copyright (C) 1995 B&M&T Corporation             }
{      }
{      Written by Vitaly Miryanov                       }
{                                                       }
{}

program TestDos;

uses WinDos, Use32;

var
  I: Integer;
  SR: TSearchRec;
  FileName: array[0..fsPathName] of Char;

procedure TestFileSplit(FileName: PChar);
var
  Dir:  array[0..fsDirectory] of Char;
  Name: array[0..fsFileName] of Char;
  Ext:  array[0..fsExtension] of Char;
begin
  FileSplit(FileName, Dir, Name, Ext);
  WriteLn('Full name: ',FileName, ' Dir="',Dir, '" Name="',Name, '" Ext="',Ext,'"');
end;

begin
  { FindFirst/FindNext/FindClose }
  WriteLn('List of all files and directories in the current directory');
  WriteLn('          Name       Size');
  FindFirst('*.*', faAnyFile, SR);
  while DosError = 0 do
  begin
    WriteLn(SR.Name:14, SR.Size:11);
    FindNext(SR);
  end;
{$IFDEF OS2}
  FindClose(SR);
{$ENDIF}
 { FileSearch/GetEnvVar }
  FileSearch(FileName, 'cmd.exe', GetEnvVar('Path'));
  if FileName[0] = #0
    then WriteLn('CMD.EXE is not found')
    else WriteLn('CMD.EXE full path is ', FileName);
 { FileExpand }
 WriteLn('Fully qualified name for the "..\.\QQ" is ', FileExpand(FileName, '..\.\qq'));
 WriteLn('Fully qualified name for the "QQ"      is ', FileExpand(FileName, 'qq'));
 WriteLn('Fully qualified name for the "\QQ"     is ', FileExpand(FileName, '\qq'));
 WriteLn('Fully qualified name for the "C:QQ"    is ', FileExpand(FileName, 'c:qq'));
 { FileSplit }
 TestFileSplit('D:\DIR\FILENAME.EXT');
 TestFileSplit('D:\DIR.EXT\FILENAME');
 TestFileSplit('DIR\FILENAME.EXT');
 TestFileSplit('\FILENAME.EXT');
 TestFileSplit('FILENAME.EXT');
 TestFileSplit('FILENAME');
 { CreateDir }
 CreateDir('qq');
 if DosError <> 0 then WriteLn('Error creating directory, Error Code = ', DosError);
 { SetCurDir }
 ChDir('qq');
 if DosError <> 0 then WriteLn('Cannot change current directory, Error Code = ', DosError);
 { GetCurDir }
 WriteLn('Current directory: ', GetCurDir(FileName, 0));
 { RemoveDir }
 ChDir('..');
 RemoveDir('qq');
 if DosError <> 0 then WriteLn('Cannot remove directory ''qq'', Error Code = ', DosError);
 { GetArgCount/GetArgStr }
 WriteLn('The following parameters have been passed');
 WriteLn('-----------------------------------------');
 WriteLn('PROGRAM NAME: ', GetArgStr(FileName, 0, fsPathName));
 for I := 1 to GetArgCount do
 WriteLn('ARG[', I, '] = ', GetArgStr(FileName, I, fsPathName));
end.
