/*
 * Inspire Remora Installation Script
 */

'@Echo off'
'cls'

say'     '
say'                    Inspire Remora Installation Routine                 '
say'                  Remora is copyright (c) 1995 Inspire Software,        '
say'                      Justin Kilimnik, All rights reserved              '
say'     '

rc = stream('remora.exe','c','query exists')
if rc = '' then
do
  say 'Sorry, Remora.exe not found.  Please run from the directory where Remora.EXE'
  say 'and Remora.HLP exist.'
  exit
end

say ''
say 'About to create objects for Inspire Remora.'
say ''

say 'Press [Enter] to continue...'
pull dummy .
say ''
assflt = ';ASSOCFILTER=*.CAL'

/* save current directory */

curdir = directory()

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

say "Creating Inspire Remora folder and objects..."

/* first, create Inspire folder */

title = "Inspire Remora"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<Remora_Folder>;OPEN=DEFAULT'
result=SysCreateObject(classname,title,location,setup,f)

if result = 0 then
do
  assflt = ''
  existed = 'TRUE'
  say ''
  say 'The Inspire Remora folder already exists.'
  say 'Should I update? (Y/n)'
  parse upper pull dummy
  if left(dummy,1) = 'N' then exit
  say ''
end

/* now, create program objects in Inspire Remora folder */

title = "Inspire Remora"
classname = 'WPProgram'
location = '<Remora_Folder>'
setup = 'OBJECT=<Remora_Program>;EXENAME='curdir'\REMORA.EXE;STARTUPDIR='curdir assflt
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u 

/* Install in startup folder */
title = "Check Remora for Events"
location = '<WP_START>'
setup = 'OBJECTID=<Remora_Bootup>;EXENAME='curdir'\Remora.EXE;STARTUPDIR='curdir';PARAMETERS=/B'
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

rc = stream('README.TXT','c','query exists')
if rc \= '' then
do
  title = "Readme.Txt"
  classname = 'WPShadow'
  location = '<Remora_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

/* Final words */

say 'To move Inspire Remora to another directory, move the files, delete the Inspire'
say 'Remora folder, then rerun INSTALL.  To remove Inspire Remora, run UNINSTAL and '
say 'follow its directions.'
say ''
say "Thankyou for Installing Inspire Remora!"

