@ECHO OFF
CLS
ECHO.
ECHO *********************************************************************
ECHO * NEWNOS.BAT - Updates to latest versions of REDIR                  *
ECHO *                                                                   *
ECHO * This batch file provides a new version of REDIR.EXE that fixes    *
ECHO * the problems listed in NOSPS.TXT.                                 *
ECHO *                                                                   *
ECHO * Be sure you have copied your present copy of REDIR.EXE to this    *
ECHO * directory. Your present copy of REDIR.EXE will be backed up to    *
ECHO * REDIR.BAK.                                                        *
ECHO *                                                                   *
ECHO * Press CTRL-C now to abort running batch file.                     *
ECHO *********************************************************************
ECHO.
PAUSE

IF NOT EXIST REDIR.EXE GOTO  ERR1RED
IF NOT EXIST NEWRED.EXE GOTO ERR4RED

IF EXIST REDIR.BAK GOTO ERR2RED

:INSTALLRED
ECHO.
ECHO Copying old redirector to REDIR.BAK ..
COPY REDIR.EXE REDIR.BAK
ECHO.

ECHO Installing new redirector ...
NEWRED INFILE=REDIR.EXE OUTFILE=_REDR_.EXE
IF ERRORLEVEL 1 GOTO    ERR3RED

@ECHO OFF
COPY _REDR_.EXE REDIR.EXE
DEL _REDR_.EXE
ECHO. 
GOTO DONERED

:ERR1RED
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO REDIR.EXE not found in this directory - please copy REDIR.EXE from
ECHO your network dirctory to this directory and run NEWNOS again. 
ECHO.
GOTO EXIT

:ERR2RED
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO REDIR.BAK already exists ! it will be overwritten.
ECHO Press CTRL-C to abort
ECHO.
PAUSE
IF EXIST _REDR_.EXE DEL _REDR_.EXE
IF EXIST TEMPFILE DEL TEMPFILE
GOTO INSTALLRED

:ERR3RED
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO Operation unsuccessful. Make sure you copy REDIR.EXE from your network
ECHO directory to this directory and run NEWNOS again.
GOTO EXIT

:ERR4RED
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO NEWRED.EXE not found in this directory - please run NEWNOS at the
ECHO directory that has NOSPS.EXE.
GOTO EXIT

:DONERED
ECHO                * Redirector successfully patched *
ECHO        *                                                            *
ECHO        * If this machine is a server, copy REDIR.EXE and SERVER.EXE *
ECHO        * to your network directory, the default is \lantasti.       *
ECHO        * If this machine is not a server. copy only REDIR.EXE to    *
ECHO        * your network directory.                                    *
ECHO        *                                                            *
ECHO.
ECHO.   
