//---------------------------------------------------------------------------------------------
// File DROPON.CPP
//---------------------------------------------------------------------------------------------
#define INCL_WIN

#include <os2.h>
#include <string.h>

MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

HAB   hab;
HWND  hwndFrame, hwndClient;

main (int argc, char *argv[])
     {
     HMQ   hmq;
     QMSG  qmsg;
     ULONG flFrameFlags = FCF_TITLEBAR |FCF_SYSMENU |FCF_SIZEBORDER |FCF_MINMAX |FCF_TASKLIST |FCF_SHELLPOSITION;
     CHAR  szClient[] = "CLIENT";

     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);

     WinRegisterClass (hab, szClient, ClientWndProc, CS_SIZEREDRAW, 0);

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,
                                     WS_VISIBLE,
                                     &flFrameFlags,
                                     szClient,
                                     "Dropzone (Not the Snipes film)",
                                     0,
                                     NULLHANDLE,
                                     0,
                                     &hwndClient);
     if (argc > 1)
          WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                        argv[1],
                        "File dropped on icon",
                        0, MB_OK);

     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);

     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     return(0);
     }

MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mpParm1, MPARAM mpParm2)
     {
     PDRAGINFO pDragInfo;
     PDRAGITEM pDragItem;

     switch (msg)
          {
          case WM_ERASEBACKGROUND:              // Standard backgroundcolor
	     return MRFROMSHORT(TRUE);             // in client Area

          //--------------------------------------------------------------------
          // May a drop be performed (only if one object, and its a text object)
          //--------------------------------------------------------------------
          case DM_DRAGOVER:
               {
               pDragInfo = (PDRAGINFO) mpParm1;
               DrgAccessDraginfo( pDragInfo );
               pDragItem = DrgQueryDragitemPtr( pDragInfo, 0 );
               //---------------------------------------------------------------
               // Don't accept multi select
               //---------------------------------------------------------------
               if (pDragInfo->cditem > 1 || !DrgVerifyType(pDragItem, DRT_TEXT))
                    return ( MPFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN) );
               else
                    return ( MPFROM2SHORT (DOR_DROP, DO_UNKNOWN) );
               }

          case DM_DROP:
               {
               char dragname[CCHMAXPATH];
               pDragInfo = (PDRAGINFO) mpParm1;
               DrgAccessDraginfo( pDragInfo);
               pDragItem = DrgQueryDragitemPtr(pDragInfo, 0);
               DrgQueryStrName(pDragItem->hstrContainerName, CCHMAXPATH, dragname);
               DrgQueryStrName(pDragItem->hstrSourceName, CCHMAXPATH, dragname+strlen(dragname));

               WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                        dragname,
                        "File dropped Client area",
                        0, MB_OK);
               }
          break;
          }
     return (WinDefWindowProc (hwnd,msg,mpParm1,mpParm2));
     }

